/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.List;
import java.util.Map;
import jscover.server.HttpRequest;
import jscover.util.IoUtils;

public class ProxyService {
    private IoUtils ioUtils = IoUtils.getInstance();

    protected void handleProxyGet(HttpRequest request, OutputStream os) {
        this.handleProxyRequest(request, os, "GET");
    }

    protected void handleProxyHead(HttpRequest request, OutputStream os) {
        this.handleProxyRequest(request, os, "HEAD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProxyRequest(HttpRequest request, OutputStream os, String method) {
        URL url = request.getUrl();
        Socket socket = null;
        InputStream remoteInputStream = null;
        OutputStream remoteOutputStream = null;
        try {
            int port = url.getPort();
            socket = new Socket(url.getHost(), port == -1 ? 80 : port);
            remoteInputStream = socket.getInputStream();
            remoteOutputStream = socket.getOutputStream();
            PrintWriter remotePrintWriter = new PrintWriter(remoteOutputStream);
            String uri = this.getRawURI(url);
            remotePrintWriter.print(method + " " + uri + " HTTP/1.0\n");
            this.sendHeaders(request, remotePrintWriter);
            this.ioUtils.copyNoClose(remoteInputStream, os);
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProxyPost(HttpRequest request, String data, OutputStream os) {
        URL url = request.getUrl();
        Socket socket = null;
        InputStream remoteInputStream = null;
        OutputStream remoteOutputStream = null;
        try {
            int port = url.getPort();
            socket = new Socket(url.getHost(), port == -1 ? 80 : port);
            remoteInputStream = socket.getInputStream();
            remoteOutputStream = socket.getOutputStream();
            PrintWriter remotePrintWriter = new PrintWriter(remoteOutputStream);
            String uri = this.getRawURI(url);
            remotePrintWriter.print(String.format("POST %s HTTP/1.0\n", uri));
            this.sendHeaders(request, remotePrintWriter);
            this.ioUtils.copyNoClose(new ByteArrayInputStream(data.getBytes()), remoteOutputStream);
            this.ioUtils.copyNoClose(remoteInputStream, os);
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.ioUtils.closeQuietly(remoteOutputStream);
            this.ioUtils.closeQuietly(remoteInputStream);
        }
    }

    String getRawURI(URL url) {
        String uri = url.getPath();
        if (url.getQuery() != null && url.getQuery().length() != 0) {
            uri = uri + "?" + url.getQuery();
        }
        return uri;
    }

    private void sendHeaders(HttpRequest request, PrintWriter remotePrintWriter) {
        Map<String, List<String>> clientHeaders = request.getHeaders();
        for (String header : clientHeaders.keySet()) {
            List<String> values = clientHeaders.get(header);
            for (String value : values) {
                remotePrintWriter.print(String.format("%s: %s\n", header, value));
            }
        }
        remotePrintWriter.print("\n");
        remotePrintWriter.flush();
    }

    public String getUrl(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return this.ioUtils.toString(conn.getInputStream());
    }
}

