/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.acls.sid.SidRetrievalStrategy;
import org.springframework.security.acls.sid.SidRetrievalStrategyImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class AclAuthorizationStrategyImpl
implements AclAuthorizationStrategy {
    private GrantedAuthority gaGeneralChanges;
    private GrantedAuthority gaModifyAuditing;
    private GrantedAuthority gaTakeOwnership;
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();

    public AclAuthorizationStrategyImpl(GrantedAuthority[] auths) {
        Assert.notEmpty((Object[])auths, (String)"GrantedAuthority[] with three elements required");
        Assert.isTrue((auths.length == 3 ? 1 : 0) != 0, (String)"GrantedAuthority[] with three elements required");
        this.gaTakeOwnership = auths[0];
        this.gaModifyAuditing = auths[1];
        this.gaGeneralChanges = auths[2];
    }

    public void securityCheck(Acl acl, int changeType) {
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null || !SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) {
            throw new AccessDeniedException("Authenticated principal required to operate with ACLs");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid currentUser = new PrincipalSid(authentication);
        if (((Object)currentUser).equals(acl.getOwner()) && (changeType == 2 || changeType == 0)) {
            return;
        }
        GrantedAuthority requiredAuthority = null;
        if (changeType == 1) {
            requiredAuthority = this.gaModifyAuditing;
        } else if (changeType == 2) {
            requiredAuthority = this.gaGeneralChanges;
        } else if (changeType == 0) {
            requiredAuthority = this.gaTakeOwnership;
        } else {
            throw new IllegalArgumentException("Unknown change type");
        }
        GrantedAuthority[] auths = authentication.getAuthorities();
        for (int i = 0; i < auths.length; ++i) {
            if (!requiredAuthority.equals(auths[i])) continue;
            return;
        }
        Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
        if (acl.isGranted(new Permission[]{BasePermission.ADMINISTRATION}, sids, false)) {
            return;
        }
        throw new AccessDeniedException("Principal does not have required ACL permissions to perform requested operation");
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }
}

