/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.joda.convert.StringConverter;

abstract class ReflectionStringConverter<T>
implements StringConverter<T> {
    final Class<T> cls;
    final Method toString;

    ReflectionStringConverter(Class<T> clazz, Method method) {
        if (method.getParameterTypes().length != 0) {
            throw new IllegalStateException("ToString method must have no parameters");
        }
        if (method.getReturnType() != String.class) {
            throw new IllegalStateException("ToString method must return a String");
        }
        this.cls = clazz;
        this.toString = method;
    }

    @Override
    public String convertToString(T t) {
        try {
            return (String)this.toString.invoke(t, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Method is not accessible");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException.getCause());
        }
    }

    public String toString() {
        return "RefectionStringConverter[" + this.cls.getSimpleName() + "]";
    }
}

