/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.Parameter;
import org.teiid.logging.LogManager;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.TranslatedCommand;

public abstract class JDBCBaseExecution
implements Execution {
    protected Connection connection;
    protected ExecutionContext context;
    protected JDBCExecutionFactory executionFactory;
    protected Command command;
    protected boolean trimString;
    protected int fetchSize;
    protected Statement statement;

    protected JDBCBaseExecution(Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory jef) {
        this.connection = connection;
        this.context = context;
        this.executionFactory = jef;
        this.trimString = jef.isTrimStrings();
        this.fetchSize = context.getBatchSize();
        this.command = command;
    }

    protected void bind(PreparedStatement stmt, List<?> params, List<?> batchValues) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            Object paramValue = params.get(i);
            Object value = null;
            Class paramType = null;
            if (paramValue instanceof Literal) {
                Literal litParam = (Literal)paramValue;
                value = litParam.getValue();
                paramType = litParam.getType();
            } else {
                Parameter param = (Parameter)paramValue;
                if (batchValues == null) {
                    throw new AssertionError((Object)"Expected batchValues when using a Parameter");
                }
                value = batchValues.get(param.getValueIndex());
                paramType = param.getType();
            }
            this.executionFactory.bindValue(stmt, value, paramType, i + 1);
        }
        if (batchValues != null) {
            stmt.addBatch();
        }
    }

    protected TranslatedCommand translateCommand(Command command) throws TranslatorException {
        TranslatedCommand translatedCommand = new TranslatedCommand(this.context, this.executionFactory);
        translatedCommand.translateCommand(command);
        if (translatedCommand.getSql() != null && LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Source-specific command: " + translatedCommand.getSql()});
        }
        return translatedCommand;
    }

    public synchronized void close() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Throwable)e, (Object[])new Object[]{"Exception closing"});
        }
    }

    public synchronized void cancel() throws TranslatorException {
        try {
            if (this.statement != null) {
                this.statement.cancel();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void setSizeContraints(Statement statement) {
        block2: {
            try {
                this.executionFactory.setFetchSize(this.command, this.context, statement, this.fetchSize);
            }
            catch (SQLException e) {
                if (!LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) break block2;
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.context.getRequestId(), " could not set fetch size: ", this.fetchSize});
            }
        }
    }

    protected synchronized Statement getStatement() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.connection.createStatement();
        this.setSizeContraints(this.statement);
        return this.statement;
    }

    protected synchronized CallableStatement getCallableStatement(String sql) throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.connection.prepareCall(sql);
        this.setSizeContraints(this.statement);
        return (CallableStatement)this.statement;
    }

    protected synchronized PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.connection.prepareStatement(sql);
        this.setSizeContraints(this.statement);
        return (PreparedStatement)this.statement;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void addStatementWarnings() throws SQLException {
        SQLWarning warning = this.statement.getWarnings();
        if (warning != null) {
            this.context.addWarning((Exception)warning);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) {
                while (warning != null) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.context.getRequestId() + " Warning: ", warning});
                    warning = warning.getNextWarning();
                }
            }
        }
        this.statement.clearWarnings();
    }
}

