/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.modeshape;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.NamedTable;
import org.teiid.metadata.Column;
import org.teiid.translator.jdbc.FunctionModifier;

public class IdentifierFunctionModifier
extends FunctionModifier {
    @Override
    public List<?> translate(Function function) {
        ArrayList<String> objs = new ArrayList<String>();
        List parms = function.getParameters();
        objs.add(function.getName().substring(function.getName().indexOf(95) + 1));
        objs.add("(");
        Iterator iter = parms.iterator();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            if (expr instanceof ColumnReference) {
                boolean dotAll = false;
                boolean useSelector = false;
                ColumnReference cr = (ColumnReference)expr;
                Column c = cr.getMetadataObject();
                if (c != null) {
                    if ("\"mode:properties\"".equalsIgnoreCase(c.getNameInSource())) {
                        dotAll = true;
                        useSelector = true;
                    } else if ("\"jcr:path\"".equalsIgnoreCase(c.getNameInSource())) {
                        useSelector = true;
                    }
                }
                if (useSelector) {
                    NamedTable nt = ((ColumnReference)expr).getTable();
                    if (nt.getCorrelationName() != null) {
                        objs.add(nt.getCorrelationName());
                    } else {
                        objs.add((String)nt);
                    }
                } else {
                    objs.add((String)expr);
                }
                if (dotAll) {
                    objs.add(".*");
                }
            } else {
                objs.add((String)expr);
            }
            if (!iter.hasNext()) continue;
            objs.add(", ");
        }
        objs.add(")");
        return objs;
    }
}

