/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sqlserver;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.sybase.SybaseExecutionFactory;

@Translator(name="sqlserver", description="A translator for Microsoft SQL Server Database")
public class SQLServerExecutionFactory
extends SybaseExecutionFactory {
    public static final String V_2005 = "2005";
    public static final String V_2008 = "2008";

    public SQLServerExecutionFactory() {
        this.setDatabaseVersion(V_2005);
        this.setMaxInCriteriaSize(1000);
        this.setMaxDependentInPredicates(50);
    }

    @Override
    protected void populateDateFormats() {
        this.formatMap.put("MM/dd/yy", 1);
        this.formatMap.put("yy.MM.dd", 2);
        this.formatMap.put("dd/MM/yy", 3);
        this.formatMap.put("dd.MM.yy", 4);
        this.formatMap.put("dd-MM-yy", 5);
        this.formatMap.put("dd MMM yy", 6);
        this.formatMap.put("MMM dd, yy", 7);
        this.formatMap.put("MM-dd-yy", 10);
        this.formatMap.put("yy/MM/dd", 11);
        this.formatMap.put("yyMMdd", 12);
        for (Map.Entry entry : new HashSet(this.formatMap.entrySet())) {
            this.formatMap.put(((String)entry.getKey()).replace("yy", "yyyy"), (Integer)entry.getValue() + 100);
        }
        this.formatMap.put("MMM d yyyy hh:mma", 100);
        this.formatMap.put("HH:mm:ss", 8);
        this.formatMap.put("MMM d yyyy hh:mm:ss:SSSa", 109);
        this.formatMap.put("dd MMM yyyy HH:mm:ss:SSS", 113);
        this.formatMap.put("kk:MM:ss:SSS", 14);
        this.formatMap.put("yyyy-MM-dd HH:mm:ss", 120);
        this.formatMap.put("yyyy-MM-dd HH:mm:ss.SSS", 121);
        this.formatMap.put("yyyy-MM-dd'T'HH:mm:ss.SSS", 126);
    }

    @Override
    protected List<Object> convertDateToString(Function function) {
        return Arrays.asList("replace(convert(varchar, ", function.getParameters().get(0), ", 102), '.', '-')");
    }

    @Override
    protected List<?> convertTimestampToString(Function function) {
        return Arrays.asList("convert(varchar, ", function.getParameters().get(0), ", 21)");
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (obj instanceof ColumnReference) {
            ColumnReference elem = (ColumnReference)obj;
            if (TypeFacility.RUNTIME_TYPES.STRING.equals(elem.getType()) && elem.getMetadataObject() != null && "uniqueidentifier".equalsIgnoreCase(elem.getMetadataObject().getNativeType())) {
                return Arrays.asList("cast(", elem, " as char(36))");
            }
        } else if (obj instanceof AggregateFunction) {
            AggregateFunction af = (AggregateFunction)obj;
            if (af.getName().equals("STDDEV_POP")) {
                af.setName("STDDEVP");
            } else if (af.getName().equals("STDDEV_SAMP")) {
                af.setName("STDDEV");
            } else if (af.getName().equals("VAR_POP")) {
                af.setName("VARP");
            } else if (af.getName().equals("VAR_SAMP")) {
                af.setName("VAR");
            }
        }
        return super.translate(obj, context);
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getDefaultSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("||");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SPACE");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("parsetimestamp");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    @Override
    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    @Override
    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    @Override
    public int getMaxFromGroups() {
        return -1;
    }

    @Override
    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean booleanNullable() {
        return true;
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        if (this.getDatabaseVersion().compareTo(V_2008) >= 0) {
            return super.translateLiteralDate(dateValue);
        }
        return super.translateLiteralTimestamp(new Timestamp(dateValue.getTime()));
    }

    @Override
    public boolean hasTimeType() {
        return this.getDatabaseVersion().compareTo(V_2008) >= 0;
    }

    public boolean supportsCommonTableExpressions() {
        return true;
    }

    @Override
    protected boolean supportsCrossJoin() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return true;
    }

    public boolean supportsWindowDistinctAggregates() {
        return false;
    }

    public boolean supportsWindowOrderByWithAggregates() {
        return false;
    }

    public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
        if (format == ExecutionFactory.Format.NUMBER) {
            return false;
        }
        return this.formatMap.containsKey(literal);
    }

    public boolean supportsOnlyFormatLiterals() {
        return true;
    }

    @Override
    protected boolean setFetchSizeOnCallableStatements() {
        return true;
    }
}

