/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.sybase;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.ModFunctionModifier;
import org.teiid.translator.jdbc.ParseFormatFunctionModifier;
import org.teiid.translator.jdbc.oracle.ConcatFunctionModifier;
import org.teiid.translator.jdbc.sybase.BaseSybaseExecutionFactory;
import org.teiid.translator.jdbc.sybase.SubstringFunctionModifier;

@Translator(name="sybase", description="A translator for Sybase Database")
public class SybaseExecutionFactory
extends BaseSybaseExecutionFactory {
    public static final String TWELVE_5_3 = "12.5.3";
    public static final String TWELVE_5 = "12.5";
    public static final String FIFTEEN_0_2 = "15.0.2";
    public static final String FIFTEEN_5 = "15.5";
    protected Map<String, Integer> formatMap = new HashMap<String, Integer>();
    protected boolean jtdsDriver;

    public SybaseExecutionFactory() {
        this.setDatabaseVersion(TWELVE_5);
        this.setSupportsFullOuterJoins(false);
        this.setMaxInCriteriaSize(250);
        this.setMaxDependentInPredicates(10);
        this.populateDateFormats();
    }

    protected void populateDateFormats() {
        this.formatMap.put("MM/dd/yy", 1);
        this.formatMap.put("yy.MM.dd", 2);
        this.formatMap.put("dd/MM/yy", 3);
        this.formatMap.put("dd.MM.yy", 4);
        this.formatMap.put("dd-MM-yy", 5);
        this.formatMap.put("dd MMM yy", 6);
        this.formatMap.put("MMM dd, yy", 7);
        this.formatMap.put("MM-dd-yy", 10);
        this.formatMap.put("yy/MM/dd", 11);
        this.formatMap.put("yyMMdd", 12);
        this.formatMap.put("yyddMM", 13);
        this.formatMap.put("MM/yy/dd", 14);
        this.formatMap.put("dd/yy/MM", 15);
        this.formatMap.put("MMM dd yy HH:mm:ss", 16);
        for (Map.Entry<String, Integer> entry : new HashSet<Map.Entry<String, Integer>>(this.formatMap.entrySet())) {
            this.formatMap.put(entry.getKey().replace("yy", "yyyy"), entry.getValue() + 100);
        }
        this.formatMap.put("MMM d yyyy hh:mma", 100);
        this.formatMap.put("HH:mm:ss", 8);
        this.formatMap.put("MMM d yyyy hh:mm:ss:SSSa", 109);
        this.formatMap.put("hh:mma", 17);
        this.formatMap.put("HH:mm", 18);
        this.formatMap.put("hh:mm:ss:SSSa", 19);
        this.formatMap.put("HH:mm:ss:SSS", 20);
        this.formatMap.put("yy/MM/dd HH:mm:ss", 21);
        this.formatMap.put("yy/MM/dd hh:mm:ssa", 22);
        this.formatMap.put("yyyy-MM-dd'T'HH:mm:ss", 23);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("mod", new ModFunctionModifier("%", this.getLanguageFactory()));
        if (this.nullPlusNonNullIsNull()) {
            this.registerFunctionModifier("concat", new AliasModifier("+"));
        } else {
            this.registerFunctionModifier("concat", new ConcatFunctionModifier(this.getLanguageFactory()){

                @Override
                public List<?> translate(Function function) {
                    function.setName("+");
                    return super.translate(function);
                }
            });
        }
        this.registerFunctionModifier("lcase", new AliasModifier("lower"));
        this.registerFunctionModifier("ifnull", new AliasModifier("isnull"));
        this.registerFunctionModifier("ucase", new AliasModifier("upper"));
        this.registerFunctionModifier("repeat", new AliasModifier("replicate"));
        this.registerFunctionModifier("substring", new SubstringFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("dayname", new EscapeSyntaxModifier());
        this.registerFunctionModifier("monthname", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofweek", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofyear", new EscapeSyntaxModifier());
        this.registerFunctionModifier("dayofmonth", new EscapeSyntaxModifier());
        this.registerFunctionModifier("hour", new EscapeSyntaxModifier());
        this.registerFunctionModifier("minute", new EscapeSyntaxModifier());
        this.registerFunctionModifier("quarter", new EscapeSyntaxModifier());
        this.registerFunctionModifier("second", new EscapeSyntaxModifier());
        this.registerFunctionModifier("week", new EscapeSyntaxModifier());
        this.registerFunctionModifier("length", new EscapeSyntaxModifier());
        this.registerFunctionModifier("atan2", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier(){

            @Override
            public List<?> translate(Function function) {
                if (!SybaseExecutionFactory.this.isFracSeconds(function)) {
                    return super.translate(function);
                }
                return Arrays.asList("dateadd(millisecond, ", function.getParameters().get(1), "/1000000, ", function.getParameters().get(2), ")");
            }
        });
        this.registerFunctionModifier("timestampdiff", new EscapeSyntaxModifier(){

            @Override
            public List<?> translate(Function function) {
                if (!SybaseExecutionFactory.this.isFracSeconds(function)) {
                    return super.translate(function);
                }
                return Arrays.asList("datediff(millisecond, ", function.getParameters().get(1), ",", function.getParameters().get(2), ")*1000000");
            }
        });
        ConvertModifier convertModifier = new ConvertModifier();
        convertModifier.setBooleanNullable(this.booleanNullable());
        convertModifier.addTypeMapping("smallint", 3, 4);
        convertModifier.addTypeMapping("int", 5);
        convertModifier.addTypeMapping("numeric(19,0)", 6);
        convertModifier.addTypeMapping("real", 8);
        convertModifier.addTypeMapping("double precision", 9);
        convertModifier.addTypeMapping("numeric(38, 0)", 7);
        convertModifier.addTypeMapping("numeric(38, 19)", 10);
        convertModifier.addTypeMapping("char(1)", 1);
        convertModifier.addTypeMapping("varchar(40)", 0);
        convertModifier.addTypeMapping("datetime", 11, 12, 13);
        convertModifier.addConvert(13, 12, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("cast(");
                boolean needsEnd = false;
                if (!SybaseExecutionFactory.this.nullPlusNonNullIsNull() && !ConcatFunctionModifier.isNotNull((Expression)function.getParameters().get(0))) {
                    result.add("CASE WHEN ");
                    result.add((String)function.getParameters().get(0));
                    result.add(" IS NOT NULL THEN ");
                    needsEnd = true;
                }
                result.add("'1970-01-01 ' + ");
                result.addAll(SybaseExecutionFactory.this.convertTimeToString(function));
                if (needsEnd) {
                    result.add(" END");
                }
                result.add(" AS datetime)");
                return result;
            }
        });
        convertModifier.addConvert(13, 11, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add("cast(");
                result.addAll(SybaseExecutionFactory.this.convertDateToString(function));
                result.add(" AS datetime)");
                return result;
            }
        });
        convertModifier.addConvert(12, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SybaseExecutionFactory.this.convertTimeToString(function);
            }
        });
        convertModifier.addConvert(11, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SybaseExecutionFactory.this.convertDateToString(function);
            }
        });
        convertModifier.addConvert(13, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return SybaseExecutionFactory.this.convertTimestampToString(function);
            }
        });
        convertModifier.addNumericBooleanConversions();
        this.registerFunctionModifier("convert", convertModifier);
        this.registerFunctionModifier("parsetimestamp", new ParseFormatFunctionModifier("CONVERT(DATETIME, "){

            @Override
            protected Object translateFormat(String format) {
                return SybaseExecutionFactory.this.formatMap.get(format);
            }
        });
        this.registerFunctionModifier("formattimestamp", new ParseFormatFunctionModifier("CONVERT(VARCHAR, "){

            @Override
            protected Object translateFormat(String format) {
                return SybaseExecutionFactory.this.formatMap.get(format);
            }
        });
    }

    private List<Object> convertTimeToString(Function function) {
        return Arrays.asList("convert(varchar, ", function.getParameters().get(0), ", 8)");
    }

    protected List<Object> convertDateToString(Function function) {
        return Arrays.asList("stuff(stuff(convert(varchar, ", function.getParameters().get(0), ", 102), 5, 1, '-'), 8, 1, '-')");
    }

    protected List<?> convertTimestampToString(Function function) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.addAll(this.convertDateToString(function));
        result.add(Character.valueOf('+'));
        result.addAll(this.convertTimeToString(function));
        return result;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("PI");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("ASCII");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("||");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("REPEAT");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SPACE");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        return supportedFunctions;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public int getMaxFromGroups() {
        return 50;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return this.getDatabaseVersion().compareTo(FIFTEEN_0_2) >= 0;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean booleanNullable() {
        return false;
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "CAST('" + this.formatDateValue(timestampValue) + "' AS DATETIME)";
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "CAST('" + this.formatDateValue(dateValue) + "' AS DATE)";
    }

    private boolean isFracSeconds(Function function) {
        Expression e = (Expression)function.getParameters().get(0);
        return e instanceof Literal && "SQL_TSI_FRAC_SECOND".equalsIgnoreCase((String)((Literal)e).getValue());
    }

    public boolean supportsRowLimit() {
        return this.getDatabaseVersion().startsWith("12") && this.getDatabaseVersion().compareTo(TWELVE_5_3) >= 0 || this.getDatabaseVersion().compareTo(FIFTEEN_0_2) >= 0;
    }

    @TranslatorProperty(display="JTDS Driver", description="True if the driver is the JTDS driver", advanced=true)
    public boolean isJtdsDriver() {
        return this.jtdsDriver;
    }

    public void setJtdsDriver(boolean jtdsDriver) {
        this.jtdsDriver = jtdsDriver;
    }

    protected boolean setFetchSizeOnCallableStatements() {
        return false;
    }

    @Override
    public void setFetchSize(Command command, ExecutionContext context, Statement statement, int fetchSize) throws SQLException {
        if (!this.isJtdsDriver() && !this.setFetchSizeOnCallableStatements() && statement instanceof CallableStatement) {
            return;
        }
        super.setFetchSize(command, context, statement, fetchSize);
    }
}

