/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.annotations;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.annotations.Auth;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.Filter;
import org.directwebremoting.annotations.Filters;
import org.directwebremoting.annotations.GlobalFilter;
import org.directwebremoting.annotations.Param;
import org.directwebremoting.annotations.RemoteMethod;
import org.directwebremoting.annotations.RemoteProperty;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.annotations.ScriptScope;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.create.NewCreator;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsConfigurator
implements Configurator {
    private static final String METHOD_PREFIX_IS = "is";
    private static final String METHOD_PREFIX_GET = "get";
    private static final Logger log = Logger.getLogger(AnnotationsConfigurator.class);

    @Override
    public void configure(Container container) {
        Object data = container.getBean("classes");
        if (data == null) {
            return;
        }
        if (data instanceof String) {
            String classesStr = (String)data;
            String[] classNames = classesStr.split(",");
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i].trim();
                try {
                    Class clazz = LocalUtil.classForName(className);
                    this.processClass(clazz, container);
                    continue;
                }
                catch (Exception ex) {
                    log.error("Failed to process class: " + className, ex);
                }
            }
        } else {
            try {
                this.processClass(data.getClass(), container);
            }
            catch (Exception ex) {
                log.error("Failed to process class: " + data.getClass().getName(), ex);
            }
        }
    }

    private void processClass(Class<?> clazz, Container container) throws InstantiationException, IllegalAccessException {
        GlobalFilter globalFilterAnn;
        DataTransferObject convertAnn;
        RemoteProxy createAnn = clazz.getAnnotation(RemoteProxy.class);
        if (createAnn != null) {
            this.processCreate(clazz, createAnn, container);
        }
        if ((convertAnn = clazz.getAnnotation(DataTransferObject.class)) != null) {
            this.processConvert(clazz, convertAnn, container);
        }
        if ((globalFilterAnn = clazz.getAnnotation(GlobalFilter.class)) != null) {
            this.processGlobalFilter(clazz, globalFilterAnn, container);
        }
    }

    private void processCreate(Class<?> clazz, RemoteProxy createAnn, Container container) {
        Class<? extends Creator> creator = createAnn.creator();
        String creatorClass = creator.getName();
        Map<String, String> creatorParams = this.getParamsMap(createAnn.creatorParams());
        ScriptScope scope = createAnn.scope();
        CreatorManager creatorManager = (CreatorManager)container.getBean(CreatorManager.class.getName());
        String creatorName = LocalUtil.replace(creatorClass, ".", "_");
        creatorManager.addCreatorType(creatorName, creatorClass);
        HashMap<String, String> params = new HashMap<String, String>();
        if (NewCreator.class.isAssignableFrom(creator)) {
            params.put("class", clazz.getName());
        }
        params.putAll(creatorParams);
        params.put("scope", scope.getValue());
        String name = createAnn.name();
        if (name == null || name.length() == 0) {
            name = LocalUtil.getShortClassName(clazz);
        }
        try {
            log.info("Adding class " + clazz.getName() + " as " + name);
            creatorManager.addCreator(name, creatorName, params);
        }
        catch (Exception ex) {
            log.error("Failed to add class as Creator: " + clazz.getName(), ex);
        }
        AccessControl accessControl = (AccessControl)container.getBean(AccessControl.class.getName());
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getAnnotation(RemoteMethod.class) == null) continue;
            accessControl.addIncludeRule(name, methods[i].getName());
            Auth authAnn = methods[i].getAnnotation(Auth.class);
            if (authAnn == null) continue;
            accessControl.addRoleRestriction(name, methods[i].getName(), authAnn.role());
        }
        Filters filtersAnn = clazz.getAnnotation(Filters.class);
        if (filtersAnn != null) {
            Filter[] fs = filtersAnn.value();
            for (int i = 0; i < fs.length; ++i) {
                this.processFilter(fs[i], name, container);
            }
        } else {
            Filter filterAnn = clazz.getAnnotation(Filter.class);
            if (filterAnn != null) {
                this.processFilter(filterAnn, name, container);
            }
        }
    }

    private void processFilter(Filter filterAnn, String name, Container container) {
        Map<String, String> filterParams = this.getParamsMap(filterAnn.params());
        AjaxFilter filter = (AjaxFilter)LocalUtil.classNewInstance(name, filterAnn.type().getName(), AjaxFilter.class);
        if (filter != null) {
            LocalUtil.setParams(filter, filterParams, null);
            AjaxFilterManager filterManager = (AjaxFilterManager)container.getBean(AjaxFilterManager.class.getName());
            filterManager.addAjaxFilter(filter, name);
        }
    }

    private void processConvert(Class<?> clazz, DataTransferObject convertAnn, Container container) throws InstantiationException, IllegalAccessException {
        Class<? extends Converter> converter = convertAnn.converter();
        String converterClass = converter.getName();
        Map<String, String> params = this.getParamsMap(convertAnn.params());
        ConverterManager converterManager = (ConverterManager)container.getBean(ConverterManager.class.getName());
        String converterName = LocalUtil.replace(converterClass, ".", "_");
        converterManager.addConverterType(converterName, converterClass);
        if (BeanConverter.class.isAssignableFrom(converter)) {
            StringBuilder properties = new StringBuilder();
            HashSet<Field> fields = new HashSet<Field>();
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            fields.addAll(Arrays.asList(clazz.getFields()));
            for (Field field : fields) {
                if (field.getAnnotation(RemoteProperty.class) == null) continue;
                properties.append(',').append(field.getName());
            }
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name;
                if (methods[i].getAnnotation(RemoteProperty.class) == null || !(name = methods[i].getName()).startsWith(METHOD_PREFIX_GET) && !name.startsWith(METHOD_PREFIX_IS)) continue;
                name = name.startsWith(METHOD_PREFIX_GET) ? name.substring(3) : name.substring(2);
                name = Introspector.decapitalize(name);
                properties.append(',').append(name);
            }
            if (properties.length() > 0) {
                properties.deleteCharAt(0);
                params.put("include", properties.toString());
            }
        }
        converterManager.addConverter(clazz.getName(), converterName, params);
    }

    private void processGlobalFilter(Class<?> clazz, GlobalFilter globalFilterAnn, Container container) throws InstantiationException, IllegalAccessException {
        if (!AjaxFilter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not an AjaxFilter implementation");
        }
        Map<String, String> filterParams = this.getParamsMap(globalFilterAnn.params());
        AjaxFilter filter = (AjaxFilter)clazz.newInstance();
        if (filter != null) {
            LocalUtil.setParams(filter, filterParams, null);
            AjaxFilterManager filterManager = (AjaxFilterManager)container.getBean(AjaxFilterManager.class.getName());
            filterManager.addAjaxFilter(filter);
        }
    }

    private Map<String, String> getParamsMap(Param[] params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Param p = params[i];
                result.put(p.name(), p.value());
            }
        }
        return result;
    }
}

