/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.EBCDICWriter;
import nu.xom.Element;
import nu.xom.Namespaces;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.TextWriter;
import nu.xom.TextWriterFactory;
import nu.xom.UnicodeWriter;
import nu.xom.UnsynchronizedBufferedWriter;
import nu.xom.XMLException;
import org.xml.sax.helpers.NamespaceSupport;

public class Serializer {
    private TextWriter escaper;
    private boolean preserveBaseURI = false;
    private NamespaceSupport namespaces = new NamespaceSupport();

    public Serializer(OutputStream out) {
        try {
            this.setOutputStream(out, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new NullPointerException("Null encoding");
        }
        this.setOutputStream(out, encoding);
    }

    public void setOutputStream(OutputStream out) throws IOException {
        this.flush();
        int maxLength = this.getMaxLength();
        int indent = this.getIndent();
        String lineSeparator = this.getLineSeparator();
        boolean nfc = this.getUnicodeNormalizationFormC();
        String encoding = this.escaper.getEncoding();
        boolean lineSeparatorSet = this.escaper.lineSeparatorSet;
        this.setOutputStream(out, encoding);
        this.setIndent(indent);
        this.setMaxLength(maxLength);
        this.setUnicodeNormalizationFormC(nfc);
        if (lineSeparatorSet) {
            this.setLineSeparator(lineSeparator);
        }
    }

    private void setOutputStream(OutputStream out, String encoding) throws UnsupportedEncodingException {
        String encodingUpperCase;
        if (out == null) {
            throw new NullPointerException("Null OutputStream");
        }
        String string = encodingUpperCase = "UTF-8".equals(encoding) ? "UTF-8" : encoding.toUpperCase(Locale.ENGLISH);
        Writer writer = encodingUpperCase.equals("UTF-8") ? new OutputStreamWriter(out, "UTF-8") : (encodingUpperCase.equals("UTF-16") || encodingUpperCase.equals("ISO-10646-UCS-2") ? new OutputStreamWriter(out, "UnicodeBig") : (encodingUpperCase.equals("IBM037") || encodingUpperCase.equals("CP037") || encodingUpperCase.equals("EBCDIC-CP-US") || encodingUpperCase.equals("EBCDIC-CP-CA") || encodingUpperCase.equals("EBCDIC-CP-WA") || encodingUpperCase.equals("EBCDIC-CP-NL") || encodingUpperCase.equals("CSIBM037") ? new EBCDICWriter(out) : (encodingUpperCase.equals("ISO-8859-11") || encodingUpperCase.equals("TIS-620") ? new OutputStreamWriter(out, "TIS620") : new OutputStreamWriter(out, encoding))));
        writer = new UnsynchronizedBufferedWriter(writer);
        this.escaper = TextWriterFactory.getTextWriter(writer, encoding);
    }

    public void write(Document doc) throws IOException {
        this.escaper.reset();
        this.namespaces.reset();
        this.namespaces.declarePrefix("", "");
        this.writeXMLDeclaration();
        int childCount = doc.getChildCount();
        int i = 0;
        while (i < childCount) {
            this.writeChild(doc.getChild(i));
            this.escaper.breakLine();
            ++i;
        }
        this.escaper.flush();
    }

    protected void writeXMLDeclaration() throws IOException {
        this.escaper.writeUncheckedMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeUncheckedMarkup(this.escaper.getEncoding());
        this.escaper.writeUncheckedMarkup("\"?>");
        this.escaper.breakLine();
    }

    protected void write(Element element) throws IOException {
        boolean hasRealChildren = false;
        int childCount = element.getChildCount();
        int i = 0;
        while (i < childCount) {
            Text t;
            Node child = element.getChild(i);
            if (!child.isText() || !(t = (Text)child).isEmpty()) {
                hasRealChildren = true;
                break;
            }
            ++i;
        }
        if (hasRealChildren) {
            boolean wasPreservingWhiteSpace = this.escaper.isPreserveSpace();
            this.writeStartTag(element);
            int i2 = 0;
            while (i2 < childCount) {
                Node child = element.getChild(i2);
                if (this.escaper.getNFC() && child.isText()) {
                    Text t = (Text)child;
                    while (i2 < childCount - 1) {
                        Node next = element.getChild(i2 + 1);
                        if (!next.isText()) break;
                        t = new Text(String.valueOf(t.getValue()) + next.getValue());
                        ++i2;
                    }
                    this.writeChild(t);
                } else {
                    this.writeChild(child);
                }
                ++i2;
            }
            this.writeEndTag(element);
            this.escaper.setPreserveSpace(wasPreservingWhiteSpace);
        } else {
            this.writeEmptyElementTag(element);
        }
    }

    private boolean hasNonTextChildren(Element element) {
        int childCount = element.getChildCount();
        int i = 0;
        while (i < childCount) {
            if (!element.getChild(i).isText()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void writeEndTag(Element element) throws IOException {
        this.escaper.decrementIndent();
        if (this.escaper.getIndent() > 0 && !this.escaper.isPreserveSpace() && this.hasNonTextChildren(element)) {
            this.escaper.breakLine();
        }
        this.escaper.write('<');
        this.escaper.write('/');
        this.escaper.writeName(element.getQualifiedName());
        this.escaper.write('>');
        this.namespaces.popContext();
    }

    protected void writeStartTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.write('>');
        this.escaper.incrementIndent();
        String xmlSpaceValue = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
        if (xmlSpaceValue != null) {
            if ("preserve".equals(xmlSpaceValue)) {
                this.escaper.setPreserveSpace(true);
            } else if ("default".equals(xmlSpaceValue)) {
                this.escaper.setPreserveSpace(false);
            }
        }
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.write('/');
        this.escaper.write('>');
        this.namespaces.popContext();
    }

    private void writeTagBeginning(Element element) throws IOException {
        this.namespaces.pushContext();
        if (this.escaper.isIndenting() && !this.escaper.isPreserveSpace() && !this.escaper.justBroke()) {
            this.escaper.breakLine();
        }
        this.escaper.write('<');
        this.escaper.writeName(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
    }

    protected void writeAttributes(Element element) throws IOException {
        if (this.preserveBaseURI) {
            ParentNode parent = element.getParent();
            if (element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null) {
                String baseValue = element.getBaseURI();
                if (parent == null || parent.isDocument() || !element.getBaseURI().equals(parent.getBaseURI())) {
                    this.escaper.write(' ');
                    Attribute baseAttribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", baseValue);
                    this.write(baseAttribute);
                }
            }
        }
        int attributeCount = element.getAttributeCount();
        int i = 0;
        while (i < attributeCount) {
            Attribute attribute = element.getAttribute(i);
            this.escaper.write(' ');
            this.write(attribute);
            ++i;
        }
    }

    protected void writeNamespaceDeclarations(Element element) throws IOException {
        String prefix = element.getNamespacePrefix();
        if (!"xml".equals(prefix)) {
            this.writeNamespaceDeclarationIfNecessary(prefix, element.getNamespaceURI());
        }
        int attCount = element.getAttributeCount();
        int i = 0;
        while (i < attCount) {
            Attribute att = element.getAttribute(i);
            String attPrefix = att.getNamespacePrefix();
            if (attPrefix.length() != 0 && !"xml".equals(attPrefix)) {
                this.writeNamespaceDeclarationIfNecessary(attPrefix, att.getNamespaceURI());
            }
            ++i;
        }
        Namespaces namespaces = element.namespaces;
        if (namespaces == null) {
            return;
        }
        int namespaceCount = namespaces.size();
        int i2 = 0;
        while (i2 < namespaceCount) {
            String additionalPrefix = namespaces.getPrefix(i2);
            String uri = namespaces.getURI(additionalPrefix);
            this.writeNamespaceDeclarationIfNecessary(additionalPrefix, uri);
            ++i2;
        }
    }

    private void writeNamespaceDeclarationIfNecessary(String prefix, String uri) throws IOException {
        String currentValue = this.namespaces.getURI(prefix);
        if (currentValue == null && "".equals(uri)) {
            return;
        }
        if (uri.equals(currentValue)) {
            return;
        }
        this.escaper.write(' ');
        this.writeNamespaceDeclaration(prefix, uri);
    }

    protected void writeNamespaceDeclaration(String prefix, String uri) throws IOException {
        this.namespaces.declarePrefix(prefix, uri);
        if ("".equals(prefix)) {
            this.escaper.writeUncheckedMarkup("xmlns");
        } else {
            this.escaper.writeUncheckedMarkup("xmlns:");
            this.escaper.writeName(prefix);
        }
        this.escaper.write('=');
        this.escaper.write('\"');
        this.escaper.writePCDATA(uri);
        this.escaper.write('\"');
    }

    protected void write(Attribute attribute) throws IOException {
        this.escaper.writeName(attribute.getQualifiedName());
        this.escaper.write('=');
        this.escaper.write('\"');
        this.escaper.writeAttributeValue(attribute.getValue());
        this.escaper.write('\"');
    }

    protected void write(Comment comment) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeUncheckedMarkup("<!--");
        this.escaper.writeMarkup(comment.getValue());
        this.escaper.writeUncheckedMarkup("-->");
    }

    protected void write(ProcessingInstruction instruction) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeUncheckedMarkup("<?");
        this.escaper.writeName(instruction.getTarget());
        String value = instruction.getValue();
        if (!"".equals(value)) {
            this.escaper.write(' ');
            this.escaper.writeMarkup(value);
        }
        this.escaper.writeUncheckedMarkup("?>");
    }

    protected void write(Text text) throws IOException {
        String value = text.getValue();
        if (text.isCDATASection() && value.indexOf("]]>") == -1) {
            if (!(this.escaper instanceof UnicodeWriter)) {
                int length = value.length();
                int i = 0;
                while (i < length) {
                    if (this.escaper.needsEscaping(value.charAt(i))) {
                        this.escaper.writePCDATA(value);
                        return;
                    }
                    ++i;
                }
            }
            this.escaper.writeUncheckedMarkup("<![CDATA[");
            this.escaper.writeMarkup(value);
            this.escaper.writeUncheckedMarkup("]]>");
        } else {
            if (this.isBoundaryWhitespace(text, value)) {
                return;
            }
            this.escaper.writePCDATA(value);
        }
    }

    private boolean isBoundaryWhitespace(Text text, String value) {
        if (this.getIndent() <= 0) {
            return false;
        }
        ParentNode parent = text.getParent();
        if (parent == null) {
            return "".equals(value.trim());
        }
        int childCount = parent.getChildCount();
        if (childCount == 1) {
            return false;
        }
        if (!"".equals(value.trim())) {
            return false;
        }
        int position = parent.indexOf(text);
        Node previous = null;
        Node next = null;
        if (position != 0) {
            previous = parent.getChild(position - 1);
        }
        if (position != childCount - 1) {
            next = parent.getChild(position + 1);
        }
        return !(previous != null && previous.isText() || next != null && next.isText());
    }

    protected void write(DocType doctype) throws IOException {
        this.escaper.writeUncheckedMarkup("<!DOCTYPE ");
        this.escaper.writeName(doctype.getRootElementName());
        if (doctype.getPublicID() != null) {
            this.escaper.writeMarkup(" PUBLIC \"" + doctype.getPublicID() + "\" \"" + doctype.getSystemID() + "\"");
        } else if (doctype.getSystemID() != null) {
            this.escaper.writeMarkup(" SYSTEM \"" + doctype.getSystemID() + "\"");
        }
        String internalDTDSubset = doctype.getInternalDTDSubset();
        if (!internalDTDSubset.equals("")) {
            this.escaper.writeUncheckedMarkup(" [");
            this.escaper.breakLine();
            this.escaper.setInDocType(true);
            this.escaper.writeMarkup(internalDTDSubset);
            this.escaper.setInDocType(false);
            this.escaper.write(']');
        }
        this.escaper.write('>');
    }

    protected void writeChild(Node node) throws IOException {
        if (node.isElement()) {
            this.write((Element)node);
        } else if (node.isText()) {
            this.write((Text)node);
        } else if (node.isComment()) {
            this.write((Comment)node);
        } else if (node.isProcessingInstruction()) {
            this.write((ProcessingInstruction)node);
        } else if (node.isDocType()) {
            this.write((DocType)node);
        } else {
            throw new XMLException("Cannot write a " + node.getClass().getName() + " from the writeChild() method");
        }
    }

    protected final void writeEscaped(String text) throws IOException {
        this.escaper.writePCDATA(text);
    }

    protected final void writeAttributeValue(String value) throws IOException {
        this.escaper.writeAttributeValue(value);
    }

    protected final void writeRaw(String text) throws IOException {
        this.escaper.writeMarkup(text);
    }

    protected final void breakLine() throws IOException {
        this.escaper.breakLine();
    }

    public void flush() throws IOException {
        this.escaper.flush();
    }

    public int getIndent() {
        return this.escaper.getIndent();
    }

    public void setIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Indent cannot be negative");
        }
        this.escaper.setIndent(indent);
    }

    public String getLineSeparator() {
        return this.escaper.getLineSeparator();
    }

    public void setLineSeparator(String lineSeparator) {
        this.escaper.setLineSeparator(lineSeparator);
    }

    public int getMaxLength() {
        return this.escaper.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.escaper.setMaxLength(maxLength);
    }

    public boolean getPreserveBaseURI() {
        return this.preserveBaseURI;
    }

    public void setPreserveBaseURI(boolean preserve) {
        this.preserveBaseURI = preserve;
    }

    public String getEncoding() {
        return this.escaper.getEncoding();
    }

    public void setUnicodeNormalizationFormC(boolean normalize) {
        this.escaper.setNFC(normalize);
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.escaper.getNFC();
    }

    protected final int getColumnNumber() {
        return this.escaper.getColumnNumber();
    }
}

