/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.URIUtil;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class XOMHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected Document document;
    protected String documentBaseURI;
    protected ParentNode parent;
    protected ParentNode current;
    protected ArrayList parents;
    protected boolean inProlog;
    protected boolean inDTD;
    protected int position;
    protected Locator locator;
    protected DocType doctype;
    protected StringBuffer internalDTDSubset;
    protected NodeFactory factory;
    boolean usingCrimson = false;
    private static final String[] CRLF_SP;
    private static final String[] LF_SP;
    private static final String[] SPACES;
    private static final String[] CRLF_TAB;
    private static final String[] LF_TAB;
    private static final String[] TABS;
    protected String textString = null;
    protected StringBuffer buffer = null;
    protected boolean inExternalSubset = false;
    protected boolean inCDATA = false;
    protected boolean finishedCDATA = false;

    static {
        int size = 50;
        char[] spaceChars = new char[size + 2];
        spaceChars[0] = 13;
        spaceChars[1] = 10;
        int i = 2;
        while (i < spaceChars.length) {
            spaceChars[i] = 32;
            ++i;
        }
        String spaces = new String(spaceChars);
        CRLF_SP = new String[size];
        LF_SP = new String[size];
        SPACES = new String[size];
        int j = 0;
        while (j < size) {
            XOMHandler.CRLF_SP[j] = spaces.substring(0, j + 2);
            XOMHandler.LF_SP[j] = spaces.substring(1, j + 2);
            XOMHandler.SPACES[j] = spaces.substring(2, j + 2);
            ++j;
        }
        char[] tabChars = new char[size + 2];
        tabChars[0] = 13;
        tabChars[1] = 10;
        int i2 = 2;
        while (i2 < tabChars.length) {
            tabChars[i2] = 9;
            ++i2;
        }
        String tabs = new String(tabChars);
        CRLF_TAB = new String[size];
        LF_TAB = new String[size];
        TABS = new String[size];
        int j2 = 0;
        while (j2 < size) {
            XOMHandler.CRLF_TAB[j2] = tabs.substring(0, j2 + 2);
            XOMHandler.LF_TAB[j2] = tabs.substring(1, j2 + 2);
            XOMHandler.TABS[j2] = tabs.substring(2, j2 + 2);
            ++j2;
        }
    }

    XOMHandler(NodeFactory factory) {
        this.factory = factory;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    Document getDocument() {
        return this.document;
    }

    void freeMemory() {
        this.document = null;
        this.parent = null;
        this.current = null;
        this.parents = null;
        this.locator = null;
        this.doctype = null;
        this.internalDTDSubset = null;
    }

    public void startDocument() {
        this.inDTD = false;
        this.document = this.factory.startMakingDocument();
        this.parent = this.document;
        this.current = this.document;
        this.parents = new ArrayList();
        this.parents.add(this.document);
        this.inProlog = true;
        this.position = 0;
        this.textString = null;
        this.doctype = null;
        if (this.locator != null) {
            this.documentBaseURI = this.locator.getSystemId();
            this.document.setBaseURI(this.documentBaseURI);
        }
        this.buffer = null;
    }

    public void endDocument() {
        this.factory.finishMakingDocument(this.document);
        this.parents.remove(this.parents.size() - 1);
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        Element element;
        this.flushText();
        if (this.parent != this.document) {
            element = this.factory.startMakingElement(qualifiedName, namespaceURI);
        } else {
            element = this.factory.makeRootElement(qualifiedName, namespaceURI);
            if (element == null) {
                throw new NullPointerException("Factory failed to create root element.");
            }
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.add(element);
        if (element != null) {
            String qName;
            String baseURI;
            if (this.parent != this.document) {
                this.parent.appendChild(element);
            }
            if (this.locator != null && (baseURI = this.locator.getSystemId()) != null && !baseURI.equals(this.documentBaseURI)) {
                element.setActualBaseURI(baseURI);
            }
            int length = attributes.getLength();
            int i = 0;
            while (i < length) {
                qName = attributes.getQName(i);
                if (!qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    String namespace = attributes.getURI(i);
                    String value = attributes.getValue(i);
                    Nodes nodes = this.factory.makeAttribute(qName, namespace, value, XOMHandler.convertStringToType(attributes.getType(i)));
                    int numberChildren = 0;
                    int j = 0;
                    while (j < nodes.size()) {
                        Node node = nodes.get(j);
                        if (node.isAttribute()) {
                            this.factory.addAttribute(element, (Attribute)node);
                        } else {
                            this.factory.insertChild(element, node, numberChildren++);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < length) {
                String namespacePrefix;
                String currentValue;
                String namespaceName;
                qName = attributes.getQName(i);
                if (qName.startsWith("xmlns:")) {
                    namespaceName = attributes.getValue(i);
                    if (!namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = qName.substring(6))) && !namespacePrefix.equals(element.getNamespacePrefix())) {
                        element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                    }
                } else if (qName.equals("xmlns") && !(namespaceName = attributes.getValue(i)).equals(currentValue = element.getNamespaceURI(namespacePrefix = "")) && !"".equals(element.getNamespacePrefix())) {
                    element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                }
                ++i;
            }
            this.parent = element;
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.current = (ParentNode)this.parents.remove(this.parents.size() - 1);
        this.flushText();
        if (this.current != null) {
            this.parent = this.current.getParent();
            Nodes result = this.factory.finishMakingElement((Element)this.current);
            if (result.size() != 1 || result.get(0) != this.current) {
                if (!this.parent.isDocument()) {
                    int childCount = this.parent.getChildCount();
                    try {
                        this.parent.removeChild(childCount - 1);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new XMLException("Factory detached element in finishMakingElement()", ex);
                    }
                    int i = 0;
                    while (i < result.size()) {
                        Node node = result.get(i);
                        if (node.isAttribute()) {
                            ((Element)this.parent).addAttribute((Attribute)node);
                        } else {
                            this.parent.appendChild(node);
                        }
                        ++i;
                    }
                } else {
                    Document doc = (Document)this.parent;
                    Element currentRoot = doc.getRootElement();
                    boolean beforeRoot = true;
                    int i = 0;
                    while (i < result.size()) {
                        Node node = result.get(i);
                        if (node.isElement()) {
                            if (node != currentRoot) {
                                if (!beforeRoot) {
                                    throw new IllegalAddException("Factory returned multiple roots");
                                }
                                doc.setRootElement((Element)node);
                            }
                            beforeRoot = false;
                        } else if (beforeRoot) {
                            doc.insertChild(node, doc.indexOf(doc.getRootElement()));
                        } else {
                            doc.appendChild(node);
                        }
                        ++i;
                    }
                    if (beforeRoot) {
                        throw new WellformednessException("Factory attempted to remove the root element");
                    }
                }
            }
        }
    }

    static Attribute.Type convertStringToType(String saxType) {
        if (saxType.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (saxType.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (saxType.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (saxType.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (saxType.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (saxType.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (saxType.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (saxType.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (saxType.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (saxType.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (saxType.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    private static String firstCharacters(char[] text, int start, int length) {
        if (length < SPACES.length) {
            int i = start + length - 1;
            char c = text[i];
            if (c == ' ' || c == '\t') {
                while (--i >= start && text[i] == c) {
                }
            } else {
                c = ' ';
            }
            switch (i + 1 - start) {
                case 0: {
                    return c == ' ' ? SPACES[length] : TABS[length];
                }
                case 1: {
                    if (text[start] != '\n') break;
                    return c == ' ' ? LF_SP[length - 1] : LF_TAB[length - 1];
                }
                case 2: {
                    if (text[start] != '\r' || text[start + 1] != '\n') break;
                    return c == ' ' ? CRLF_SP[length - 2] : CRLF_TAB[length - 2];
                }
            }
        }
        return new String(text, start, length);
    }

    public void characters(char[] text, int start, int length) {
        if (length <= 0) {
            return;
        }
        if (this.textString == null) {
            this.textString = XOMHandler.firstCharacters(text, start, length);
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(this.textString.length() + length);
                this.buffer.append(this.textString);
            }
            this.buffer.append(text, start, length);
        }
        if (this.finishedCDATA) {
            this.inCDATA = false;
        }
    }

    private void flushText() {
        if (this.buffer != null) {
            this.textString = this.buffer.toString();
            this.buffer = null;
        }
        if (this.textString != null) {
            Nodes result = !this.inCDATA ? this.factory.makeText(this.textString) : this.factory.makeCDATASection(this.textString);
            int i = 0;
            while (i < result.size()) {
                Node node = result.get(i);
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                } else {
                    this.parent.appendChild(node);
                }
                ++i;
            }
            this.textString = null;
        }
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    public void ignorableWhitespace(char[] text, int start, int length) {
        this.characters(text, start, length);
    }

    public void processingInstruction(String target, String data) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes result = this.factory.makeProcessingInstruction(target, data);
        int i = 0;
        while (i < result.size()) {
            Node node = result.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                } else if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                } else {
                    this.parent.appendChild(node);
                }
            } else if (node.isProcessingInstruction() || node.isComment()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
            } else {
                throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
            }
            ++i;
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
        if (name.startsWith("%")) {
            return;
        }
        this.flushText();
        throw new XMLException("Could not resolve entity " + name);
    }

    public void startDTD(String rootName, String publicID, String systemID) {
        this.inDTD = true;
        Nodes result = this.factory.makeDocType(rootName, publicID, systemID);
        int i = 0;
        while (i < result.size()) {
            Node node = result.get(i);
            this.document.insertChild(node, this.position);
            ++this.position;
            if (node.isDocType()) {
                DocType doctype = (DocType)node;
                this.internalDTDSubset = new StringBuffer();
                this.doctype = doctype;
            }
            ++i;
        }
    }

    public void endDTD() {
        this.inDTD = false;
        if (this.doctype != null) {
            this.doctype.fastSetInternalDTDSubset(this.internalDTDSubset.toString());
        }
    }

    public void startEntity(String name) {
        if (name.equals("[dtd]")) {
            this.inExternalSubset = true;
        }
    }

    public void endEntity(String name) {
        if (name.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    public void startCDATA() {
        if (this.textString == null) {
            this.inCDATA = true;
        }
        this.finishedCDATA = false;
    }

    public void endCDATA() {
        this.finishedCDATA = true;
    }

    public void comment(char[] text, int start, int length) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes result = this.factory.makeComment(new String(text, start, length));
        int i = 0;
        while (i < result.size()) {
            Node node = result.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                } else if (node instanceof Attribute) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                } else {
                    this.parent.appendChild(node);
                }
            } else if (node.isComment() || node.isProcessingInstruction()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
            } else {
                throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
            }
            ++i;
        }
    }

    public void elementDecl(String name, String model) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ELEMENT ");
            this.internalDTDSubset.append(name);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(model);
            if (model.indexOf("#PCDATA") > 0 && model.indexOf(124) > 0 && model.endsWith(")")) {
                this.internalDTDSubset.append('*');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    protected boolean inInternalSubset() {
        if (!this.usingCrimson && !this.inExternalSubset) {
            return true;
        }
        String currentURI = this.locator.getSystemId();
        if (currentURI == this.documentBaseURI) {
            return true;
        }
        return currentURI.equals(this.documentBaseURI);
    }

    public void attributeDecl(String elementName, String attributeName, String type, String mode, String defaultValue) {
        if (type.startsWith("NOTATION ") && type.indexOf(40) == -1 && !type.endsWith(")")) {
            type = "NOTATION (" + type.substring("NOTATION ".length()) + ")";
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ATTLIST ");
            this.internalDTDSubset.append(elementName);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(attributeName);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(type);
            if (mode != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append(mode);
            }
            if (defaultValue != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append('\"');
                this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDefaultAttributeValues(defaultValue));
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void internalEntityDecl(String name, String value) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (name.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(name.substring(1));
            } else {
                this.internalDTDSubset.append(name);
            }
            this.internalDTDSubset.append(" \"");
            this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDeclarations(value));
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void externalEntityDecl(String name, String publicID, String systemID) {
        if (this.inInternalSubset() && this.doctype != null) {
            String documentURL;
            this.internalDTDSubset.append("  <!ENTITY ");
            if (name.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(name.substring(1));
            } else {
                this.internalDTDSubset.append(name);
            }
            if (this.locator != null && URIUtil.isAbsolute(systemID) && (documentURL = this.locator.getSystemId()) != null) {
                if (documentURL.startsWith("file:/") && !documentURL.startsWith("file:///")) {
                    documentURL = "file://" + documentURL.substring(5);
                }
                if (systemID.startsWith("file:/") && !systemID.startsWith("file:///")) {
                    systemID = "file://" + systemID.substring(5);
                }
                systemID = URIUtil.relativize(documentURL, systemID);
            }
            if (publicID != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(systemID);
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
            }
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void notationDecl(String name, String publicID, String systemID) {
        if (systemID != null) {
            systemID = XOMHandler.escapeReservedCharactersInDeclarations(systemID);
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!NOTATION ");
            this.internalDTDSubset.append(name);
            if (publicID != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append('\"');
                if (systemID != null) {
                    this.internalDTDSubset.append(" \"");
                    this.internalDTDSubset.append(systemID);
                    this.internalDTDSubset.append('\"');
                }
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (publicID != null) {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(notationName);
            } else {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(notationName);
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    private static String escapeReservedCharactersInDeclarations(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    result.append("&#x0D;");
                    break;
                }
                case '\u000e': {
                    break;
                }
                case '\u000f': {
                    break;
                }
                case '\u0010': {
                    break;
                }
                case '\u0011': {
                    break;
                }
                case '\u0012': {
                    break;
                }
                case '\u0013': {
                    break;
                }
                case '\u0014': {
                    break;
                }
                case '\u0015': {
                    break;
                }
                case '\u0016': {
                    break;
                }
                case '\u0017': {
                    break;
                }
                case '\u0018': {
                    break;
                }
                case '\u0019': {
                    break;
                }
                case '\u001a': {
                    break;
                }
                case '\u001b': {
                    break;
                }
                case '\u001c': {
                    break;
                }
                case '\u001d': {
                    break;
                }
                case '\u001e': {
                    break;
                }
                case '\u001f': {
                    break;
                }
                case ' ': {
                    result.append(' ');
                    break;
                }
                case '!': {
                    result.append('!');
                    break;
                }
                case '\"': {
                    result.append("&#x22;");
                    break;
                }
                case '#': {
                    result.append('#');
                    break;
                }
                case '$': {
                    result.append('$');
                    break;
                }
                case '%': {
                    result.append("&#x25;");
                    break;
                }
                case '&': {
                    result.append("&#x26;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static String escapeReservedCharactersInDefaultAttributeValues(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    result.append("&#x0D;");
                    break;
                }
                case '\u000e': {
                    break;
                }
                case '\u000f': {
                    break;
                }
                case '\u0010': {
                    break;
                }
                case '\u0011': {
                    break;
                }
                case '\u0012': {
                    break;
                }
                case '\u0013': {
                    break;
                }
                case '\u0014': {
                    break;
                }
                case '\u0015': {
                    break;
                }
                case '\u0016': {
                    break;
                }
                case '\u0017': {
                    break;
                }
                case '\u0018': {
                    break;
                }
                case '\u0019': {
                    break;
                }
                case '\u001a': {
                    break;
                }
                case '\u001b': {
                    break;
                }
                case '\u001c': {
                    break;
                }
                case '\u001d': {
                    break;
                }
                case '\u001e': {
                    break;
                }
                case '\u001f': {
                    break;
                }
                case ' ': {
                    result.append(' ');
                    break;
                }
                case '!': {
                    result.append('!');
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '#': {
                    result.append('#');
                    break;
                }
                case '$': {
                    result.append('$');
                    break;
                }
                case '%': {
                    result.append("&#x25;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\'': {
                    result.append('\'');
                    break;
                }
                case '(': {
                    result.append('(');
                    break;
                }
                case ')': {
                    result.append(')');
                    break;
                }
                case '*': {
                    result.append('*');
                    break;
                }
                case '+': {
                    result.append('+');
                    break;
                }
                case ',': {
                    result.append(',');
                    break;
                }
                case '-': {
                    result.append('-');
                    break;
                }
                case '.': {
                    result.append('.');
                    break;
                }
                case '/': {
                    result.append('/');
                    break;
                }
                case '0': {
                    result.append('0');
                    break;
                }
                case '1': {
                    result.append('1');
                    break;
                }
                case '2': {
                    result.append('2');
                    break;
                }
                case '3': {
                    result.append('3');
                    break;
                }
                case '4': {
                    result.append('4');
                    break;
                }
                case '5': {
                    result.append('5');
                    break;
                }
                case '6': {
                    result.append('6');
                    break;
                }
                case '7': {
                    result.append('7');
                    break;
                }
                case '8': {
                    result.append('8');
                    break;
                }
                case '9': {
                    result.append('9');
                    break;
                }
                case ':': {
                    result.append(':');
                    break;
                }
                case ';': {
                    result.append(';');
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

