/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.MalformedURIException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.xinclude.BadEncodingAttributeException;
import nu.xom.xinclude.BadHTTPHeaderException;
import nu.xom.xinclude.BadHrefAttributeException;
import nu.xom.xinclude.BadParseAttributeException;
import nu.xom.xinclude.EncodingHeuristics;
import nu.xom.xinclude.InclusionLoopException;
import nu.xom.xinclude.MisplacedFallbackException;
import nu.xom.xinclude.NoIncludeLocationException;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XPointer;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

public class XIncluder {
    private static String version = System.getProperty("java.version");
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";

    private XIncluder() {
    }

    public static Document resolve(Document in) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Builder builder = new Builder();
        return XIncluder.resolve(in, builder);
    }

    public static Document resolve(Document in, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Document copy = new Document(in);
        XIncluder.resolveInPlace(copy, builder);
        return copy;
    }

    public static void resolveInPlace(Document in) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        XIncluder.resolveInPlace(in, new Builder());
    }

    public static void resolveInPlace(Document in, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        ArrayList stack = new ArrayList();
        XIncluder.resolveInPlace(in, builder, stack);
    }

    private static void resolveInPlace(Document in, Builder builder, ArrayList baseURLs) throws IOException, ParsingException, XIncludeException {
        String base = in.getBaseURI();
        if (base != null && base.startsWith("file:///")) {
            base = "file:/" + base.substring(8);
        }
        baseURLs.add(base);
        Element root = in.getRootElement();
        XIncluder.resolve(root, builder, baseURLs);
        baseURLs.remove(baseURLs.size() - 1);
    }

    private static void resolve(Element element, Builder builder, ArrayList baseURLs) throws IOException, ParsingException, XIncludeException {
        XIncluder.resolve(element, builder, baseURLs, null);
    }

    private static void resolve(Element element, Builder builder, ArrayList baseURLs, Document originalDoc) throws IOException, ParsingException, XIncludeException {
        block39: {
            if (XIncluder.isIncludeElement(element)) {
                XIncluder.verifyIncludeElement(element);
                String parse = element.getAttributeValue("parse");
                if (parse == null) {
                    parse = "xml";
                }
                String xpointer = element.getAttributeValue("xpointer");
                String encoding = element.getAttributeValue("encoding");
                String href = element.getAttributeValue("href");
                if ("".equals(href)) {
                    href = null;
                }
                ParentNode parent = element.getParent();
                String base = element.getBaseURI();
                URL baseURL = null;
                try {
                    baseURL = new URL(base);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                URL url = null;
                try {
                    if (baseURL != null && href != null) {
                        url = XIncluder.absolutize(baseURL, href);
                    } else if (href != null) {
                        try {
                            XIncluder.testURISyntax(href);
                            url = new URL(href);
                        }
                        catch (MalformedURIException ex) {
                            if (baseURL == null) {
                                throw new BadHrefAttributeException("Could not resolve relative URI " + href + " because the xi:include element does" + " not have a base URI.", href);
                            }
                            throw new BadHrefAttributeException("Illegal IRI in href attribute", href);
                        }
                    }
                    String accept = element.getAttributeValue("accept");
                    XIncluder.checkHeader(accept);
                    String acceptLanguage = element.getAttributeValue("accept-language");
                    XIncluder.checkHeader(acceptLanguage);
                    if (parse.equals("xml")) {
                        Nodes replacements;
                        String parentLanguage = "";
                        if (parent instanceof Element) {
                            parentLanguage = XIncluder.getXMLLangValue((Element)parent);
                        }
                        if (url != null) {
                            replacements = XIncluder.downloadXMLDocument(url, xpointer, builder, baseURLs, accept, acceptLanguage, parentLanguage);
                            int i = 0;
                            while (i < replacements.size()) {
                                Node child = replacements.get(i);
                                if (child instanceof Element) {
                                    String noFragment = child.getBaseURI();
                                    if (noFragment.indexOf(35) >= 0) {
                                        noFragment = noFragment.substring(0, noFragment.indexOf(35));
                                    }
                                    Element baseless = (Element)child;
                                    String parentBase = parent.getBaseURI();
                                    if (parentBase != null && !"".equals(parentBase)) {
                                        parentBase = XIncluder.getDirectoryBase(parentBase);
                                    }
                                    if (noFragment.startsWith(parentBase)) {
                                        noFragment = noFragment.substring(parentBase.length());
                                    }
                                    Attribute baseAttribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", noFragment);
                                    baseless.addAttribute(baseAttribute);
                                }
                                ++i;
                            }
                        } else {
                            Document parentDoc = element.getDocument();
                            if (parentDoc == null) {
                                parentDoc = originalDoc;
                            }
                            Nodes originals = XPointer.query(parentDoc, xpointer);
                            replacements = new Nodes();
                            int i = 0;
                            while (i < originals.size()) {
                                Node original = originals.get(i);
                                if (XIncluder.contains((Element)original, element)) {
                                    throw new InclusionLoopException("Element tried to include itself");
                                }
                                Node copy = original.copy();
                                replacements.append(copy);
                                ++i;
                            }
                            replacements = XIncluder.resolveXPointerSelection(replacements, builder, baseURLs, parentDoc);
                        }
                        if (parent instanceof Element) {
                            int position = parent.indexOf(element);
                            int i = 0;
                            while (i < replacements.size()) {
                                Node child = replacements.get(i);
                                parent.insertChild(child, position + i);
                                ++i;
                            }
                            element.detach();
                        } else {
                            Node child;
                            Document doc = (Document)parent;
                            int i = 0;
                            while (true) {
                                child = replacements.get(i);
                                ++i;
                                if (child instanceof Element) break;
                                doc.insertChild(child, doc.indexOf(element));
                            }
                            doc.setRootElement((Element)child);
                            Element root = doc.getRootElement();
                            int position = doc.indexOf(root);
                            int j = i;
                            while (j < replacements.size()) {
                                doc.insertChild(replacements.get(j), position + 1 + j - i);
                                ++j;
                            }
                        }
                        break block39;
                    }
                    if (parse.equals("text")) {
                        Nodes replacements = XIncluder.downloadTextDocument(url, encoding, builder, accept, acceptLanguage);
                        int j = 0;
                        while (j < replacements.size()) {
                            Node replacement = replacements.get(j);
                            if (replacement instanceof Attribute) {
                                ((Element)parent).addAttribute((Attribute)replacement);
                            } else {
                                parent.insertChild(replacement, parent.indexOf(element));
                            }
                            ++j;
                        }
                        parent.removeChild(element);
                        break block39;
                    }
                    throw new BadParseAttributeException("Bad value for parse attribute: " + parse, element.getDocument().getBaseURI());
                }
                catch (IOException ex) {
                    XIncluder.processFallback(element, builder, baseURLs, parent, ex);
                }
                catch (XPointerSyntaxException ex) {
                    XIncluder.processFallback(element, builder, baseURLs, parent, ex);
                }
                catch (XPointerResourceException ex) {
                    XIncluder.processFallback(element, builder, baseURLs, parent, ex);
                }
            } else {
                if (XIncluder.isFallbackElement(element)) {
                    throw new MisplacedFallbackException("Fallback element outside include element", element.getDocument().getBaseURI());
                }
                Elements children = element.getChildElements();
                int i = 0;
                while (i < children.size()) {
                    XIncluder.resolve(children.get(i), builder, baseURLs);
                    ++i;
                }
            }
        }
    }

    private static String getDirectoryBase(String parentBase) {
        if (parentBase.endsWith("/")) {
            return parentBase;
        }
        int lastSlash = parentBase.lastIndexOf(47);
        return parentBase.substring(0, lastSlash + 1);
    }

    private static void verifyIncludeElement(Element element) throws XIncludeException {
        XIncluder.testHref(element);
        XIncluder.testForFragmentIdentifier(element);
        XIncluder.verifyEncoding(element);
        XIncluder.testForForbiddenChildElements(element);
    }

    private static void testHref(Element include) throws NoIncludeLocationException {
        String href = include.getAttributeValue("href");
        String xpointer = include.getAttributeValue("xpointer");
        if (href == null && xpointer == null) {
            throw new NoIncludeLocationException("Missing href attribute", include.getDocument().getBaseURI());
        }
    }

    private static void testForFragmentIdentifier(Element include) throws BadHrefAttributeException {
        String href = include.getAttributeValue("href");
        if (href != null && href.indexOf(35) > -1) {
            throw new BadHrefAttributeException("fragment identifier in URI " + href, include.getBaseURI());
        }
    }

    private static void verifyEncoding(Element include) throws BadEncodingAttributeException {
        String encoding = include.getAttributeValue("encoding");
        if (encoding == null) {
            return;
        }
        char[] text = encoding.toCharArray();
        if (text.length == 0) {
            throw new BadEncodingAttributeException("Empty encoding attribute", include.getBaseURI());
        }
        char c = text[0];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            throw new BadEncodingAttributeException("Illegal value for encoding attribute: " + encoding, include.getBaseURI());
        }
        int i = 1;
        while (i < text.length) {
            c = text[i];
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) {
                throw new BadEncodingAttributeException("Illegal value for encoding attribute: " + encoding, include.getBaseURI());
            }
            ++i;
        }
    }

    private static URL absolutize(URL baseURL, String href) throws MalformedURLException, BadHrefAttributeException {
        Element parent = new Element("c");
        parent.setBaseURI(baseURL.toExternalForm());
        Element child = new Element("c");
        parent.appendChild(child);
        child.addAttribute(new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", href));
        URL result = new URL(child.getBaseURI());
        if (!"".equals(href) && result.equals(baseURL) && !baseURL.toExternalForm().endsWith(href)) {
            throw new BadHrefAttributeException(String.valueOf(href) + " is not a syntactically correct IRI");
        }
        return result;
    }

    private static void testURISyntax(String href) {
        Element e = new Element("e");
        e.setNamespaceURI(href);
    }

    private static String getXMLLangValue(Element element) {
        Attribute lang;
        while ((lang = element.getAttribute("lang", "http://www.w3.org/XML/1998/namespace")) == null) {
            ParentNode parent = element.getParent();
            if (parent == null) {
                return "";
            }
            if (parent instanceof Document) {
                return "";
            }
            element = (Element)parent;
        }
        return lang.getValue();
    }

    private static Nodes resolveXPointerSelection(Nodes in, Builder builder, ArrayList baseURLs, Document original) throws IOException, ParsingException, XIncludeException {
        Element preinclude = (Element)in.get(0);
        return XIncluder.resolveSilently(preinclude, builder, baseURLs, original);
    }

    private static boolean contains(ParentNode ancestor, Node descendant) {
        Node parent = descendant;
        while (parent != null) {
            if (parent == ancestor) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static Nodes resolveSilently(Element element, Builder builder, ArrayList baseURLs, Document originalDoc) throws IOException, ParsingException, XIncludeException {
        if (XIncluder.isIncludeElement(element) || XIncluder.isFallbackElement(element)) {
            throw new RuntimeException("XOM BUG: include or fallback element passed to resolveSilently; please report with a test case");
        }
        Elements children = element.getChildElements();
        int i = 0;
        while (i < children.size()) {
            XIncluder.resolve(children.get(i), builder, baseURLs, originalDoc);
            ++i;
        }
        return new Nodes(element);
    }

    private static void testForForbiddenChildElements(Element element) throws XIncludeException {
        int fallbacks = 0;
        Elements children = element.getChildElements();
        int size = children.size();
        int i = 0;
        while (i < size) {
            Element child = children.get(i);
            if (XINCLUDE_NS.equals(child.getNamespaceURI())) {
                if ("fallback".equals(child.getLocalName())) {
                    if (++fallbacks > 1) {
                        throw new XIncludeException("Multiple fallback elements", element.getDocument().getBaseURI());
                    }
                } else {
                    throw new XIncludeException("Include element contains an include child", element.getDocument().getBaseURI());
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void processFallback(Element includeElement, Builder builder, ArrayList baseURLs, ParentNode parent, Exception ex) throws XIncludeException, IOException, ParsingException {
        fallback = includeElement.getFirstChildElement("fallback", "http://www.w3.org/2001/XInclude");
        if (fallback != null) ** GOTO lbl15
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        ex2 = new XIncludeException(ex.getMessage(), includeElement.getDocument().getBaseURI());
        ex2.initCause(ex);
        throw ex2;
lbl-1000:
        // 1 sources

        {
            child = fallback.getChild(0);
            if (child instanceof Element) {
                XIncluder.resolve((Element)child, builder, baseURLs);
            }
            child = fallback.getChild(0);
            child.detach();
            parent.insertChild(child, parent.indexOf(includeElement));
lbl15:
            // 2 sources

            ** while (fallback.getChildCount() > 0)
        }
lbl16:
        // 1 sources

        includeElement.detach();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Nodes downloadXMLDocument(URL source, String xpointer, Builder builder, ArrayList baseURLs, String accept, String acceptLanguage, String parentLanguage) throws IOException, ParsingException, XIncludeException, XPointerSyntaxException, XPointerResourceException {
        Node node;
        int i;
        Nodes included;
        Document doc;
        String base = source.toExternalForm();
        if (xpointer == null && baseURLs.indexOf(base) != -1) {
            throw new InclusionLoopException("Tried to include the already included document " + base + " from " + baseURLs.get(baseURLs.size() - 1), (String)baseURLs.get(baseURLs.size() - 1));
        }
        URLConnection uc = source.openConnection();
        XIncluder.setHeaders(uc, accept, acceptLanguage);
        BufferedInputStream in = new BufferedInputStream(uc.getInputStream());
        try {
            doc = builder.build(in, source.toExternalForm());
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        ((InputStream)in).close();
        XIncluder.resolveInPlace(doc, builder, baseURLs);
        if (xpointer != null && xpointer.length() != 0) {
            included = XPointer.query(doc, xpointer);
            i = 0;
            while (i < included.size()) {
                String childLanguage;
                node = included.get(i);
                Element top = (Element)node;
                Attribute lang = top.getAttribute("lang", "http://www.w3.org/XML/1998/namespace");
                if (lang == null && !parentLanguage.equals(childLanguage = XIncluder.getXMLLangValue(top))) {
                    top.addAttribute(new Attribute("xml:lang", "http://www.w3.org/XML/1998/namespace", childLanguage));
                }
                ++i;
            }
        } else {
            included = new Nodes();
            i = 0;
            while (i < doc.getChildCount()) {
                Node child = doc.getChild(i);
                if (!(child instanceof DocType)) {
                    included.append(child);
                }
                ++i;
            }
        }
        doc.setRootElement(new Element("f"));
        i = 0;
        while (i < included.size()) {
            node = included.get(i);
            String noFragment = node.getBaseURI();
            if (noFragment.indexOf(35) >= 0) {
                noFragment = noFragment.substring(0, noFragment.indexOf(35));
            }
            node.detach();
            if (node instanceof Element) {
                ((Element)node).setBaseURI(noFragment);
            }
            ++i;
        }
        return included;
    }

    private static Nodes downloadTextDocument(URL source, String encoding, Builder builder, String accept, String language) throws IOException, XIncludeException {
        StringBuffer sb;
        BufferedInputStream in;
        block15: {
            Nodes nodes;
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            URLConnection uc = source.openConnection();
            XIncluder.setHeaders(uc, accept, language);
            String encodingFromHeader = uc.getContentEncoding();
            String contentType = uc.getContentType();
            int contentLength = uc.getContentLength();
            if (contentLength < 0) {
                contentLength = 1024;
            }
            in = new BufferedInputStream(uc.getInputStream());
            try {
                if (encodingFromHeader != null) {
                    encoding = encodingFromHeader;
                } else if (contentType != null && ((contentType = contentType.toLowerCase(Locale.ENGLISH)).equals("text/xml") || contentType.equals("application/xml") || contentType.startsWith("text/") && contentType.endsWith("+xml") || contentType.startsWith("application/") && contentType.endsWith("+xml"))) {
                    encoding = EncodingHeuristics.readEncodingFromStream(in);
                }
                if (version.startsWith("1.2") || version.startsWith("1.1")) {
                    if (encoding.equalsIgnoreCase("UTF-16")) {
                        ((InputStream)in).mark(2);
                        int first = ((InputStream)in).read();
                        encoding = first == 255 ? "UnicodeLittle" : "UnicodeBig";
                        ((InputStream)in).reset();
                    } else if (encoding.equalsIgnoreCase("UnicodeBigUnmarked")) {
                        encoding = "UnicodeBig";
                    } else if (encoding.equalsIgnoreCase("UnicodeLittleUnmarked")) {
                        encoding = "UnicodeLittle";
                    }
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, encoding));
                sb = new StringBuffer(contentLength);
                int c = ((Reader)reader).read();
                while (c != -1) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
                NodeFactory factory = builder.getNodeFactory();
                if (factory == null) break block15;
                nodes = factory.makeText(sb.toString());
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return nodes;
        }
        Nodes nodes = new Nodes(new Text(sb.toString()));
        Object var13_18 = null;
        ((InputStream)in).close();
        return nodes;
    }

    private static void setHeaders(URLConnection uc, String accept, String language) throws BadHTTPHeaderException {
        if (accept != null) {
            XIncluder.checkHeader(accept);
            uc.setRequestProperty("accept", accept);
        }
        if (language != null) {
            XIncluder.checkHeader(language);
            uc.setRequestProperty("accept-language", language);
        }
    }

    private static void checkHeader(String header) throws BadHTTPHeaderException {
        if (header == null) {
            return;
        }
        int length = header.length();
        int i = 0;
        while (i < length) {
            char c = header.charAt(i);
            if (c < ' ' || c > '~') {
                throw new BadHTTPHeaderException("Header contains illegal character 0x" + Integer.toHexString(c).toUpperCase());
            }
            ++i;
        }
    }

    private static boolean isIncludeElement(Element element) {
        return element.getLocalName().equals("include") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static boolean isFallbackElement(Element element) {
        return element.getLocalName().equals("fallback") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }
}

