/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Maps;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.xml.XmlTest;

public class AnnotationHelper {
    private static Class[] ALL_ANNOTATIONS = new Class[]{ITestAnnotation.class, IConfigurationAnnotation.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class, IDataProviderAnnotation.class, IExpectedExceptionsAnnotation.class, IFactoryAnnotation.class, IParametersAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class};
    public static Class[] CONFIGURATION_CLASSES = new Class[]{IConfigurationAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class};

    public static ITestAnnotation findTest(IAnnotationFinder finder, Class cls) {
        return (ITestAnnotation)finder.findAnnotation(cls, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, Method m) {
        return (ITestAnnotation)finder.findAnnotation(m, ITestAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder finder, Method m) {
        return (IFactoryAnnotation)finder.findAnnotation(m, IFactoryAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder finder, Constructor c) {
        return (IFactoryAnnotation)finder.findAnnotation(c, IFactoryAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, Constructor ctor) {
        return (ITestAnnotation)finder.findAnnotation(ctor, ITestAnnotation.class);
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder finder, Constructor ctor) {
        IConfigurationAnnotation result = (IConfigurationAnnotation)finder.findAnnotation(ctor, IConfigurationAnnotation.class);
        if (result == null) {
            IConfigurationAnnotation bs = (IConfigurationAnnotation)finder.findAnnotation(ctor, IBeforeSuite.class);
            IConfigurationAnnotation as = (IConfigurationAnnotation)finder.findAnnotation(ctor, IAfterSuite.class);
            IConfigurationAnnotation bt = (IConfigurationAnnotation)finder.findAnnotation(ctor, IBeforeTest.class);
            IConfigurationAnnotation at = (IConfigurationAnnotation)finder.findAnnotation(ctor, IAfterTest.class);
            IConfigurationAnnotation bg = (IConfigurationAnnotation)finder.findAnnotation(ctor, IBeforeGroups.class);
            IConfigurationAnnotation ag = (IConfigurationAnnotation)finder.findAnnotation(ctor, IAfterGroups.class);
            IConfigurationAnnotation bc = (IConfigurationAnnotation)finder.findAnnotation(ctor, IBeforeClass.class);
            IConfigurationAnnotation ac = (IConfigurationAnnotation)finder.findAnnotation(ctor, IAfterClass.class);
            IConfigurationAnnotation bm = (IConfigurationAnnotation)finder.findAnnotation(ctor, IBeforeMethod.class);
            IConfigurationAnnotation am = (IConfigurationAnnotation)finder.findAnnotation(ctor, IAfterMethod.class);
            if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
                result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
            }
        }
        return result;
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder finder, Method m) {
        IConfigurationAnnotation result = (IConfigurationAnnotation)finder.findAnnotation(m, IConfigurationAnnotation.class);
        if (result == null) {
            IConfigurationAnnotation bs = (IConfigurationAnnotation)finder.findAnnotation(m, IBeforeSuite.class);
            IConfigurationAnnotation as = (IConfigurationAnnotation)finder.findAnnotation(m, IAfterSuite.class);
            IConfigurationAnnotation bt = (IConfigurationAnnotation)finder.findAnnotation(m, IBeforeTest.class);
            IConfigurationAnnotation at = (IConfigurationAnnotation)finder.findAnnotation(m, IAfterTest.class);
            IConfigurationAnnotation bg = (IConfigurationAnnotation)finder.findAnnotation(m, IBeforeGroups.class);
            IConfigurationAnnotation ag = (IConfigurationAnnotation)finder.findAnnotation(m, IAfterGroups.class);
            IConfigurationAnnotation bc = (IConfigurationAnnotation)finder.findAnnotation(m, IBeforeClass.class);
            IConfigurationAnnotation ac = (IConfigurationAnnotation)finder.findAnnotation(m, IAfterClass.class);
            IConfigurationAnnotation bm = (IConfigurationAnnotation)finder.findAnnotation(m, IBeforeMethod.class);
            IConfigurationAnnotation am = (IConfigurationAnnotation)finder.findAnnotation(m, IAfterMethod.class);
            if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
                result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
            }
        }
        return result;
    }

    private static IConfigurationAnnotation createConfiguration(IConfigurationAnnotation bs, IConfigurationAnnotation as, IConfigurationAnnotation bt, IConfigurationAnnotation at, IConfigurationAnnotation bg, IConfigurationAnnotation ag, IConfigurationAnnotation bc, IConfigurationAnnotation ac, IConfigurationAnnotation bm, IConfigurationAnnotation am) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        if (bs != null) {
            result.setBeforeSuite(true);
            AnnotationHelper.finishInitialize(result, bs);
        }
        if (as != null) {
            result.setAfterSuite(true);
            AnnotationHelper.finishInitialize(result, as);
        }
        if (bt != null) {
            result.setBeforeTest(true);
            AnnotationHelper.finishInitialize(result, bt);
        }
        if (at != null) {
            result.setAfterTest(true);
            AnnotationHelper.finishInitialize(result, at);
        }
        if (bg != null) {
            result.setBeforeGroups(bg.getBeforeGroups());
            AnnotationHelper.finishInitialize(result, bg);
        }
        if (ag != null) {
            result.setAfterGroups(ag.getAfterGroups());
            AnnotationHelper.finishInitialize(result, ag);
        }
        if (bc != null) {
            result.setBeforeTestClass(true);
            AnnotationHelper.finishInitialize(result, bc);
        }
        if (ac != null) {
            result.setAfterTestClass(true);
            AnnotationHelper.finishInitialize(result, ac);
        }
        if (bm != null) {
            result.setBeforeTestMethod(true);
            AnnotationHelper.finishInitialize(result, bm);
        }
        if (am != null) {
            result.setAfterTestMethod(true);
            AnnotationHelper.finishInitialize(result, am);
        }
        return result;
    }

    private static void finishInitialize(ConfigurationAnnotation result, IConfigurationAnnotation bs) {
        result.setFakeConfiguration(true);
        result.setAlwaysRun(bs.getAlwaysRun());
        result.setDependsOnGroups(bs.getDependsOnGroups());
        result.setDependsOnMethods(bs.getDependsOnMethods());
        result.setDescription(bs.getDescription());
        result.setEnabled(bs.getEnabled());
        result.setGroups(bs.getGroups());
        result.setInheritGroups(bs.getInheritGroups());
        result.setParameters(bs.getParameters());
        result.setTimeOut(bs.getTimeOut());
    }

    public static Class[] getAllAnnotations() {
        return ALL_ANNOTATIONS;
    }

    public static ITestNGMethod[] findMethodsWithAnnotation(Class rootClass, Class annotationClass, IAnnotationFinder annotationFinder, XmlTest xmlTest) {
        Map<String, TestNGMethod> vResult = Maps.newHashMap();
        try {
            vResult = Maps.newHashMap();
            for (Class cls = rootClass; null != cls; cls = cls.getSuperclass()) {
                Method[] methods;
                boolean hasClassAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, cls, annotationClass);
                for (Method m : methods = cls.getDeclaredMethods()) {
                    boolean hasMethodAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, annotationClass);
                    boolean hasTestNGAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, IFactoryAnnotation.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m, ITestAnnotation.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m, CONFIGURATION_CLASSES);
                    boolean isPublic = Modifier.isPublic(m.getModifiers());
                    if ((!isPublic || !hasClassAnnotation || hasTestNGAnnotation) && !hasMethodAnnotation) continue;
                    if (AnnotationHelper.isAnnotationPresent(annotationFinder, m, IConfigurationAnnotation.class) && AnnotationHelper.isAnnotationPresent(annotationFinder, cls, ITestAnnotation.class)) {
                        Utils.log("", 3, "Method " + m + " has a configuration annotation" + " and a class-level @Test. This method will only be kept as a" + " configuration method.");
                        continue;
                    }
                    if (m.getReturnType() != Void.TYPE) {
                        Utils.log("", 3, "Method " + m + " has a @Test annotation" + " but also a return value:  ignoring it.");
                        continue;
                    }
                    String key = AnnotationHelper.createMethodKey(m);
                    if (null != vResult.get(key)) continue;
                    TestNGMethod tm = new TestNGMethod(m, annotationFinder, xmlTest);
                    vResult.put(key, tm);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        ITestNGMethod[] result = vResult.values().toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static Annotation findAnnotationSuperClasses(Class annotationClass, Class c) {
        while (c != null) {
            Object result = c.getAnnotation(annotationClass);
            if (result != null) {
                return result;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m, Class[] annotationClasses) {
        for (Class a : annotationClasses) {
            if (annotationFinder.findAnnotation(m, a) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m, Class annotationClass) {
        return annotationFinder.findAnnotation(m, annotationClass) != null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Class cls, Class annotationClass) {
        return annotationFinder.findAnnotation(cls, annotationClass) != null;
    }

    private static String createMethodKey(Method m) {
        StringBuffer result = new StringBuffer(m.getName());
        for (Class<?> paramClass : m.getParameterTypes()) {
            result.append(' ').append(paramClass.toString());
        }
        return result.toString();
    }
}

