/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class PrintOpTreeProcessor
implements NodeProcessor {
    private final PrintStream out;
    private final HashMap<Operator<? extends Serializable>, Integer> opMap = new HashMap();
    private Integer curNum = 0;

    public PrintOpTreeProcessor() {
        this.out = System.out;
    }

    public PrintOpTreeProcessor(PrintStream o) {
        this.out = o;
    }

    private String getParents(Operator<? extends Serializable> op) {
        StringBuilder ret = new StringBuilder("[");
        boolean first = true;
        if (op.getParentOperators() != null) {
            for (Operator<Serializable> parent : op.getParentOperators()) {
                if (!first) {
                    ret.append(",");
                }
                ret.append(this.opMap.get(parent));
                first = false;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    private String getChildren(Operator<? extends Serializable> op) {
        StringBuilder ret = new StringBuilder("[");
        boolean first = true;
        if (op.getChildOperators() != null) {
            for (Operator<Serializable> child : op.getChildOperators()) {
                if (!first) {
                    ret.append(",");
                }
                ret.append(this.opMap.get(child));
                first = false;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
        Operator op = (Operator)nd;
        if (this.opMap.get(op) == null) {
            Integer n = this.curNum;
            Integer n2 = this.curNum = Integer.valueOf(this.curNum + 1);
            this.opMap.put(op, n);
        }
        this.out.println("[" + this.opMap.get(op) + "] " + op.getClass().getName() + " =p=> " + this.getParents(op) + " =c=> " + this.getChildren(op));
        if (op.getConf() == null) {
            return null;
        }
        return null;
    }
}

