/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.api.AdjacencyType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;

public class Adjacency
implements TBase<Adjacency, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Adjacency");
    private static final TField NODE_FIELD_DESC = new TField("node", 11, 1);
    private static final TField CHILDREN_FIELD_DESC = new TField("children", 15, 2);
    private static final TField ADJACENCY_TYPE_FIELD_DESC = new TField("adjacencyType", 8, 3);
    private String node;
    private List<String> children;
    private AdjacencyType adjacencyType;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Adjacency() {
    }

    public Adjacency(String node, List<String> children, AdjacencyType adjacencyType) {
        this();
        this.node = node;
        this.children = children;
        this.adjacencyType = adjacencyType;
    }

    public Adjacency(Adjacency other) {
        if (other.isSetNode()) {
            this.node = other.node;
        }
        if (other.isSetChildren()) {
            ArrayList<String> __this__children = new ArrayList<String>();
            for (String other_element : other.children) {
                __this__children.add(other_element);
            }
            this.children = __this__children;
        }
        if (other.isSetAdjacencyType()) {
            this.adjacencyType = other.adjacencyType;
        }
    }

    public Adjacency deepCopy() {
        return new Adjacency(this);
    }

    @Override
    public void clear() {
        this.node = null;
        this.children = null;
        this.adjacencyType = null;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void unsetNode() {
        this.node = null;
    }

    public boolean isSetNode() {
        return this.node != null;
    }

    public void setNodeIsSet(boolean value) {
        if (!value) {
            this.node = null;
        }
    }

    public int getChildrenSize() {
        return this.children == null ? 0 : this.children.size();
    }

    public Iterator<String> getChildrenIterator() {
        return this.children == null ? null : this.children.iterator();
    }

    public void addToChildren(String elem) {
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(elem);
    }

    public List<String> getChildren() {
        return this.children;
    }

    public void setChildren(List<String> children) {
        this.children = children;
    }

    public void unsetChildren() {
        this.children = null;
    }

    public boolean isSetChildren() {
        return this.children != null;
    }

    public void setChildrenIsSet(boolean value) {
        if (!value) {
            this.children = null;
        }
    }

    public AdjacencyType getAdjacencyType() {
        return this.adjacencyType;
    }

    public void setAdjacencyType(AdjacencyType adjacencyType) {
        this.adjacencyType = adjacencyType;
    }

    public void unsetAdjacencyType() {
        this.adjacencyType = null;
    }

    public boolean isSetAdjacencyType() {
        return this.adjacencyType != null;
    }

    public void setAdjacencyTypeIsSet(boolean value) {
        if (!value) {
            this.adjacencyType = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NODE: {
                if (value == null) {
                    this.unsetNode();
                    break;
                }
                this.setNode((String)value);
                break;
            }
            case CHILDREN: {
                if (value == null) {
                    this.unsetChildren();
                    break;
                }
                this.setChildren((List)value);
                break;
            }
            case ADJACENCY_TYPE: {
                if (value == null) {
                    this.unsetAdjacencyType();
                    break;
                }
                this.setAdjacencyType((AdjacencyType)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NODE: {
                return this.getNode();
            }
            case CHILDREN: {
                return this.getChildren();
            }
            case ADJACENCY_TYPE: {
                return this.getAdjacencyType();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NODE: {
                return this.isSetNode();
            }
            case CHILDREN: {
                return this.isSetChildren();
            }
            case ADJACENCY_TYPE: {
                return this.isSetAdjacencyType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Adjacency) {
            return this.equals((Adjacency)that);
        }
        return false;
    }

    public boolean equals(Adjacency that) {
        if (that == null) {
            return false;
        }
        boolean this_present_node = this.isSetNode();
        boolean that_present_node = that.isSetNode();
        if (this_present_node || that_present_node) {
            if (!this_present_node || !that_present_node) {
                return false;
            }
            if (!this.node.equals(that.node)) {
                return false;
            }
        }
        boolean this_present_children = this.isSetChildren();
        boolean that_present_children = that.isSetChildren();
        if (this_present_children || that_present_children) {
            if (!this_present_children || !that_present_children) {
                return false;
            }
            if (!((Object)this.children).equals(that.children)) {
                return false;
            }
        }
        boolean this_present_adjacencyType = this.isSetAdjacencyType();
        boolean that_present_adjacencyType = that.isSetAdjacencyType();
        if (this_present_adjacencyType || that_present_adjacencyType) {
            if (!this_present_adjacencyType || !that_present_adjacencyType) {
                return false;
            }
            if (!this.adjacencyType.equals(that.adjacencyType)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(Adjacency other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        Adjacency typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetNode()).compareTo(typedOther.isSetNode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNode() && (lastComparison = TBaseHelper.compareTo(this.node, typedOther.node)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetChildren()).compareTo(typedOther.isSetChildren());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetChildren() && (lastComparison = TBaseHelper.compareTo(this.children, typedOther.children)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAdjacencyType()).compareTo(typedOther.isSetAdjacencyType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAdjacencyType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.adjacencyType), (Comparable)((Object)typedOther.adjacencyType))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.node = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.children = new ArrayList<String>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            String _elem2 = iprot.readString();
                            this.children.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.adjacencyType = AdjacencyType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.node != null) {
            oprot.writeFieldBegin(NODE_FIELD_DESC);
            oprot.writeString(this.node);
            oprot.writeFieldEnd();
        }
        if (this.children != null) {
            oprot.writeFieldBegin(CHILDREN_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.children.size()));
            for (String _iter3 : this.children) {
                oprot.writeString(_iter3);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.adjacencyType != null) {
            oprot.writeFieldBegin(ADJACENCY_TYPE_FIELD_DESC);
            oprot.writeI32(this.adjacencyType.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Adjacency(");
        boolean first = true;
        sb.append("node:");
        if (this.node == null) {
            sb.append("null");
        } else {
            sb.append(this.node);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("children:");
        if (this.children == null) {
            sb.append("null");
        } else {
            sb.append(this.children);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("adjacencyType:");
        if (this.adjacencyType == null) {
            sb.append("null");
        } else {
            sb.append(this.adjacencyType);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NODE, new FieldMetaData("node", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CHILDREN, new FieldMetaData("children", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ADJACENCY_TYPE, new FieldMetaData("adjacencyType", 3, new EnumMetaData(16, AdjacencyType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Adjacency.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NODE(1, "node"),
        CHILDREN(2, "children"),
        ADJACENCY_TYPE(3, "adjacencyType");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NODE;
                }
                case 2: {
                    return CHILDREN;
                }
                case 3: {
                    return ADJACENCY_TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

