/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.EnumSet;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeScope;

public class Privilege {
    private PrivilegeType priv;
    private EnumSet<PrivilegeScope> supportedScopeSet;
    public static Privilege ALL = new Privilege(PrivilegeType.ALL, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege ALTER_METADATA = new Privilege(PrivilegeType.ALTER_METADATA, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege ALTER_DATA = new Privilege(PrivilegeType.ALTER_DATA, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege CREATE = new Privilege(PrivilegeType.CREATE, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege DROP = new Privilege(PrivilegeType.DROP, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege INDEX = new Privilege(PrivilegeType.INDEX, PrivilegeScope.ALLSCOPE);
    public static Privilege LOCK = new Privilege(PrivilegeType.LOCK, PrivilegeScope.ALLSCOPE_EXCEPT_COLUMN);
    public static Privilege SELECT = new Privilege(PrivilegeType.SELECT, PrivilegeScope.ALLSCOPE);
    public static Privilege SHOW_DATABASE = new Privilege(PrivilegeType.SHOW_DATABASE, EnumSet.of(PrivilegeScope.USER_LEVEL_SCOPE));

    public static PrivilegeType getPrivTypeByToken(int token) {
        switch (token) {
            case 209: {
                return PrivilegeType.ALL;
            }
            case 211: {
                return PrivilegeType.ALTER_DATA;
            }
            case 210: {
                return PrivilegeType.ALTER_METADATA;
            }
            case 217: {
                return PrivilegeType.CREATE;
            }
            case 212: {
                return PrivilegeType.DROP;
            }
            case 213: {
                return PrivilegeType.INDEX;
            }
            case 214: {
                return PrivilegeType.LOCK;
            }
            case 215: {
                return PrivilegeType.SELECT;
            }
            case 216: {
                return PrivilegeType.SHOW_DATABASE;
            }
        }
        return PrivilegeType.UNKNOWN;
    }

    public static PrivilegeType getPrivTypeByName(String privilegeName) {
        String canonicalizedName = privilegeName.toLowerCase();
        if (canonicalizedName.equals("all")) {
            return PrivilegeType.ALL;
        }
        if (canonicalizedName.equals("update")) {
            return PrivilegeType.ALTER_DATA;
        }
        if (canonicalizedName.equals("alter")) {
            return PrivilegeType.ALTER_METADATA;
        }
        if (canonicalizedName.equals("create")) {
            return PrivilegeType.CREATE;
        }
        if (canonicalizedName.equals("drop")) {
            return PrivilegeType.DROP;
        }
        if (canonicalizedName.equals("index")) {
            return PrivilegeType.INDEX;
        }
        if (canonicalizedName.equals("lock")) {
            return PrivilegeType.LOCK;
        }
        if (canonicalizedName.equals("select")) {
            return PrivilegeType.SELECT;
        }
        if (canonicalizedName.equals("show_database")) {
            return PrivilegeType.SHOW_DATABASE;
        }
        return PrivilegeType.UNKNOWN;
    }

    private Privilege(PrivilegeType priv, EnumSet<PrivilegeScope> scopeSet) {
        this.priv = priv;
        this.supportedScopeSet = scopeSet;
    }

    public Privilege(PrivilegeType priv) {
        this.priv = priv;
    }

    public PrivilegeType getPriv() {
        return this.priv;
    }

    public void setPriv(PrivilegeType priv) {
        this.priv = priv;
    }

    public boolean supportColumnLevel() {
        return this.supportedScopeSet != null && this.supportedScopeSet.contains((Object)PrivilegeScope.COLUMN_LEVEL_SCOPE);
    }

    public boolean supportDBLevel() {
        return this.supportedScopeSet != null && this.supportedScopeSet.contains((Object)PrivilegeScope.DB_LEVEL_SCOPE);
    }

    public boolean supportTableLevel() {
        return this.supportedScopeSet != null && this.supportedScopeSet.contains((Object)PrivilegeScope.TABLE_LEVEL_SCOPE);
    }

    public String toString() {
        switch (this.priv) {
            case ALL: {
                return "All";
            }
            case ALTER_DATA: {
                return "Update";
            }
            case ALTER_METADATA: {
                return "Alter";
            }
            case CREATE: {
                return "Create";
            }
            case DROP: {
                return "Drop";
            }
            case INDEX: {
                return "Index";
            }
            case LOCK: {
                return "Lock";
            }
            case SELECT: {
                return "Select";
            }
            case SHOW_DATABASE: {
                return "Show_Database";
            }
        }
        return "Unknown";
    }

    public Privilege() {
    }

    public static enum PrivilegeType {
        ALL,
        ALTER_DATA,
        ALTER_METADATA,
        CREATE,
        DROP,
        INDEX,
        LOCK,
        SELECT,
        SHOW_DATABASE,
        UNKNOWN;

    }
}

