/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class NumberToIntegerTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;

    public NumberToIntegerTransform(Class<?> sourceType, boolean isNarrowing) {
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        return ((Number)value).intValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.INTEGER;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

