/*
 * Decompiled with CFR 0.152.
 */
package com.vertica;

import com.vertica.core.Logger;
import com.vertica.core.PGStream;
import com.vertica.jdbc3g.Jdbc3gConnection;
import com.vertica.ssl.MakeSSL;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    private static final Logger logger = new Logger();
    private static boolean logLevelSet = false;
    private Properties defaultProperties;
    private static final Object[][] knownProperties;
    private static String[] protocols;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            String string;
            if (!logLevelSet && (string = this.defaultProperties.getProperty("loglevel")) != null) {
                try {
                    Driver.setLogLevel(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return this.defaultProperties;
        }
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties properties = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            logger.debug("Can't find a classloader for the Driver; not loading driver configuration");
            return properties;
        }
        logger.debug("Loading driver configuration via classloader " + classLoader);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration<URL> enumeration = classLoader.getResources("com/vertica/driverconfig.properties");
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            URL uRL = (URL)arrayList.get(i);
            logger.debug("Loading driver configuration from: " + uRL);
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
        }
        return properties;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        Properties properties2;
        try {
            properties2 = this.getDefaultProperties();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties"), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        Properties properties3 = new Properties(properties2);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            properties3.setProperty(string2, properties.getProperty(string2));
        }
        if ((properties3 = this.parseURL(string, properties3)) == null) {
            logger.debug("Error in url: " + string);
            return null;
        }
        try {
            logger.debug("Connecting with URL: " + string);
            long l = Driver.timeout(properties3);
            if (l <= 0L) {
                return Driver.makeConnection(string, properties3);
            }
            ConnectThread connectThread = new ConnectThread(string, properties3);
            new Thread((Runnable)connectThread, "Vertica Analytic Database JDBC driver connection thread").start();
            return connectThread.getResult(l);
        }
        catch (PSQLException pSQLException) {
            logger.debug("Connection error:", pSQLException);
            throw pSQLException;
        }
        catch (Exception exception) {
            logger.debug("Unexpected connection error:", exception);
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, (Throwable)exception);
        }
    }

    private static Connection makeConnection(String string, Properties properties) throws SQLException {
        return new Jdbc3gConnection(Driver.host(properties), Driver.port(properties), Driver.user(properties), Driver.database(properties), properties, string);
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.parseURL(string, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties(properties);
        this.parseURL(string, properties2);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < knownProperties.length; ++i) {
            String string2 = (String)knownProperties[i][0];
            driverPropertyInfoArray[i] = new DriverPropertyInfo(string2, properties2.getProperty(string2));
            driverPropertyInfoArray[i].required = (Boolean)knownProperties[i][1];
            driverPropertyInfoArray[i].description = (String)knownProperties[i][2];
            if (knownProperties[i].length <= 3) continue;
            driverPropertyInfoArray[i].choices = (String[])knownProperties[i][3];
        }
        return driverPropertyInfoArray;
    }

    public static int getMajorVersionStatic() {
        return 4;
    }

    public int getMajorVersion() {
        return Driver.getMajorVersionStatic();
    }

    public static int getMinorVersionStatic() {
        return 1;
    }

    public int getMinorVersion() {
        return Driver.getMinorVersionStatic();
    }

    public static String getVersion() {
        return "Vertica JDBC Driver 4.1.19";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String string, Properties properties) throws SQLException {
        int n;
        Object object;
        int n2 = -1;
        Properties properties2 = new Properties(properties);
        String string2 = string;
        String string3 = "";
        int n3 = string.indexOf(63);
        if (n3 != -1) {
            string2 = string.substring(0, n3);
            string3 = string.substring(n3 + 1);
        }
        int n4 = string2.indexOf("[");
        int n5 = string2.indexOf("]");
        String string4 = null;
        if (n4 != -1 && n5 > n4) {
            string4 = string2.substring(n4 + 1, n5);
            string2 = string2.substring(0, n4) + "ipv6host" + string2.substring(n5 + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/", true);
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (n6 <= 3) {
                if (n6 % 2 != 1 || !((String)object).equals(":")) {
                    if (n6 % 2 != 0) return null;
                    boolean bl = n6 == 0;
                    for (n = 0; n < protocols.length; ++n) {
                        if (!((String)object).equals(protocols[n]) || n6 != 2 || n <= 0) continue;
                        properties2.setProperty("Protocol", (String)object);
                        bl = true;
                    }
                    if (!bl) {
                        return null;
                    }
                }
            } else if (n6 > 3) {
                if (n6 == 4 && ((String)object).equals("/")) {
                    n2 = 0;
                } else if (n6 == 4) {
                    properties2.setProperty("PGDBNAME", (String)object);
                    n2 = -2;
                } else if (n6 == 5 && n2 == 0 && ((String)object).equals("/")) {
                    n2 = 1;
                } else {
                    if (n6 == 5 && n2 == 0) {
                        return null;
                    }
                    if (n6 == 6 && n2 == 1) {
                        properties2.setProperty("PGHOST", (String)object);
                    } else if (n6 == 7 && ((String)object).equals(":")) {
                        n2 = 2;
                    } else if (n6 == 8 && n2 == 2) {
                        try {
                            Integer n7 = Integer.decode((String)object);
                            properties2.setProperty("PGPORT", n7.toString());
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    } else if (!(n6 != 7 && n6 != 9 || n2 != 1 && n2 != 2 || !((String)object).equals("/"))) {
                        n2 = -1;
                    } else if (n2 == -1) {
                        properties2.setProperty("PGDBNAME", (String)object);
                        n2 = -2;
                    }
                }
            }
            ++n6;
        }
        if (n6 <= 1) {
            return null;
        }
        if (string4 != null) {
            properties2.setProperty("PGHOST", string4);
        }
        object = new StringTokenizer(string3, "&");
        n6 = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string5 = ((StringTokenizer)object).nextToken();
            n = string5.indexOf(61);
            if (n == -1) {
                properties2.setProperty(string5, "");
            } else {
                properties2.setProperty(string5.substring(0, n), string5.substring(n + 1));
            }
            ++n6;
        }
        return properties2;
    }

    private static String host(Properties properties) {
        return properties.getProperty("PGHOST", "localhost");
    }

    private static int port(Properties properties) {
        return Integer.parseInt(properties.getProperty("PGPORT", "5433"));
    }

    private static String user(Properties properties) {
        return properties.getProperty("user", "");
    }

    private static String database(Properties properties) {
        return properties.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties properties) {
        try {
            return (long)(Float.parseFloat(properties.getProperty("loginTimeout", "0")) * 1000.0f);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static SQLException notImplemented(Class clazz, String string) {
        return new PSQLException(GT.tr("Method {0} is not yet implemented.", clazz.getName() + "." + string), PSQLState.NOT_IMPLEMENTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(int n) {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            logger.setLogLevel(n);
            logLevelSet = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLogLevel() {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger.getLogLevel();
        }
    }

    public static void makeSSL(PGStream pGStream, Properties properties, Logger logger) throws IOException, SQLException {
        MakeSSL.convert(pGStream, properties, logger);
    }

    public static boolean sslEnabled() {
        boolean bl = false;
        bl = true;
        return bl;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        knownProperties = new Object[][]{{"PGDBNAME", Boolean.TRUE, "Database name to connect to; may be specified directly in the JDBC URL."}, {"user", Boolean.TRUE, "Username to connect to the database as.", null}, {"PGHOST", Boolean.FALSE, "Hostname of the Vertica Analytic Database server; may be specified directly in the JDBC URL."}, {"PGPORT", Boolean.FALSE, "Port number to connect to the Vertica Analytic Database server on; may be specified directly in the JDBC URL."}, {"password", Boolean.FALSE, "Password to use when authenticating."}, {"protocolVersion", Boolean.FALSE, "Force use of a particular protocol version when connecting; if set, disables protocol version fallback."}, {"ssl", Boolean.FALSE, "Control use of SSL; any nonnull value causes SSL to be required."}, {"sslfactory", Boolean.FALSE, "Provide a SSLSocketFactory class when using SSL."}, {"sslfactoryarg", Boolean.FALSE, "Argument forwarded to constructor of SSLSocketFactory class."}, {"loglevel", Boolean.FALSE, "Control the driver's log verbosity: 0 is off, 1 is INFO, 2 is DEBUG.", new String[]{"0", "1", "2"}}, {"allowEncodingChanges", Boolean.FALSE, "Allow the user to change the client_encoding variable."}, {"logUnclosedConnections", Boolean.FALSE, "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source."}, {"prepareThreshold", Boolean.FALSE, "Default statement prepare threshold (numeric)."}, {"charSet", Boolean.FALSE, "When connecting to a pre-7.3 server, the database encoding to assume is in use."}, {"compatible", Boolean.FALSE, "Force compatibility of some features with an older version of the driver.", new String[]{"7.1", "7.2", "7.3", "7.4", "8.0", "8.1"}}, {"loginTimeout", Boolean.FALSE, "The login timeout, in seconds; 0 means no timeout beyond the normal TCP connection timout."}, {"stringtype", Boolean.FALSE, "The type to bind String parameters as (usually 'varchar'; 'unspecified' allows implicit casting to other types)", new String[]{"varchar", "unspecified"}}};
        protocols = new String[]{"jdbc", "vertica"};
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String string, Properties properties) {
            this.url = string;
            this.props = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Throwable throwable;
            Connection connection;
            try {
                connection = Driver.makeConnection(this.url, this.props);
                throwable = null;
            }
            catch (Throwable throwable2) {
                connection = null;
                throwable = throwable2;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = connection;
                    this.resultException = throwable;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long l) throws SQLException {
            long l2 = System.currentTimeMillis() + l;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long l3 = l2 - System.currentTimeMillis();
                    if (l3 <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Interrupted while attempting to connect."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                }
                return this.result;
            }
        }
    }
}

