/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGByte
implements PGType {
    private Byte val;

    public PGByte(Byte by) {
        this.val = by;
    }

    public static PGType castToServerType(Byte by, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(by == 0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -6: 
                case 5: {
                    return new PGByte(by);
                }
                case 7: {
                    return new PGFloat(new Float(by.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(by.doubleValue()));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(by.toString()));
                }
                case -1: 
                case 12: {
                    return new PGString(by.toString());
                }
            }
            return new PGUnknown(by);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{by.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

