/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGFloat
implements PGType {
    private Float val;

    protected PGFloat(Float f) {
        this.val = f;
    }

    public static PGType castToServerType(Float f, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(f.floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE);
                }
                case -5: {
                    return new PGLong(new Long(f.longValue()));
                }
                case 4: {
                    return new PGInteger(new Integer(f.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(f.shortValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(f.toString());
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(f.doubleValue()));
                }
                case 7: {
                    return new PGFloat(f);
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(f.toString()));
                }
            }
            return new PGUnknown(f);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{f.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

