/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGInteger
implements PGType {
    private Integer val;

    protected PGInteger(Integer n) {
        this.val = n;
    }

    public static PGType castToServerType(Integer n, int n2) throws PSQLException {
        try {
            switch (n2) {
                case -7: {
                    return new PGBoolean(n == 0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case 7: {
                    return new PGFloat(new Float(n.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(n.doubleValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(n.toString());
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(n.shortValue()));
                }
                case 4: {
                    return new PGInteger(n);
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(n.toString()));
                }
            }
            return new PGUnknown(n);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{n.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

