/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;

public class PGNumber
implements PGType {
    private Number val;

    protected PGNumber(Number number) {
        this.val = number;
    }

    public static PGType castToServerType(Number number, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(number.doubleValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -5: {
                    return new PGLong(new Long(number.longValue()));
                }
                case 4: {
                    return new PGInteger(new Integer(number.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(number.shortValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(number.toString());
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(number.doubleValue()));
                }
                case 7: {
                    return new PGFloat(new Float(number.floatValue()));
                }
                case 2: 
                case 3: {
                    return new PGNumber(number);
                }
            }
            return new PGUnknown(number);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{number.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

