/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGShort
implements PGType {
    Short val;

    protected PGShort(Short s) {
        this.val = s;
    }

    public static PGType castToServerType(Short s, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(s == 0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -6: 
                case 5: {
                    return new PGShort(s);
                }
                case 7: {
                    return new PGFloat(new Float(s.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(s.doubleValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(s.toString());
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(s.toString()));
                }
            }
            return new PGUnknown(s);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{s.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

