/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGDouble;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGString
implements PGType {
    String val;

    protected PGString(String string) {
        this.val = string;
    }

    public static PGType castToServerType(String string, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("t")) {
                        return new PGBoolean(Boolean.TRUE);
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0") || string.equalsIgnoreCase("f")) {
                        return new PGBoolean(Boolean.FALSE);
                    }
                    return new PGBoolean(Boolean.FALSE);
                }
                case -1: 
                case 12: {
                    return new PGString(string);
                }
                case -5: {
                    return new PGLong(new Long(Long.parseLong(string)));
                }
                case 4: {
                    return new PGInteger(new Integer(Integer.parseInt(string)));
                }
                case -6: {
                    return new PGShort(new Short(Short.parseShort(string)));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(Double.parseDouble(string)));
                }
                case 7: {
                    return new PGFloat(new Float(Float.parseFloat(string)));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(string));
                }
            }
            return new PGUnknown(string);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{string.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val;
    }
}

