/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v2;

import com.vertica.Driver;
import com.vertica.core.ConnectionFactory;
import com.vertica.core.Encoding;
import com.vertica.core.Field;
import com.vertica.core.Logger;
import com.vertica.core.PGStream;
import com.vertica.core.ProtocolConnection;
import com.vertica.core.Query;
import com.vertica.core.QueryExecutor;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.Utils;
import com.vertica.core.VectorTuple;
import com.vertica.core.v2.ProtocolConnectionImpl;
import com.vertica.util.GT;
import com.vertica.util.MD5Digest;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import com.vertica.util.UnixCrypt;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;

    public ProtocolConnection openConnectionImpl(String string, int n, String string2, String string3, Properties properties, Logger logger) throws SQLException {
        boolean bl;
        boolean bl2 = bl = properties.getProperty("ssl") != null;
        if (logger.logDebug()) {
            logger.debug("Trying to establish a protocol version 2 connection to " + string + ":" + n);
        }
        if (!Driver.sslEnabled()) {
            if (bl) {
                throw new PSQLException(GT.tr("The driver does not support SSL."), PSQLState.CONNECTION_FAILURE);
            }
            bl2 = false;
        }
        PGStream pGStream = null;
        try {
            pGStream = new PGStream(string, n);
            if (bl2) {
                pGStream = this.enableSSL(pGStream, bl, properties, logger);
            }
            this.sendStartupPacket(pGStream, string2, string3, logger);
            this.doAuthentication(pGStream, string2, properties.getProperty("password"), logger);
            ProtocolConnectionImpl protocolConnectionImpl = new ProtocolConnectionImpl(pGStream, string2, string3, logger);
            this.readStartupMessages(pGStream, protocolConnectionImpl, logger);
            this.runInitialQueries(protocolConnectionImpl, properties.getProperty("charSet"), logger);
            return protocolConnectionImpl;
        }
        catch (ConnectException connectException) {
            throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_REJECTED, (Throwable)connectException);
        }
        catch (IOException iOException) {
            if (pGStream != null) {
                try {
                    pGStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            if (pGStream != null) {
                try {
                    pGStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw sQLException;
        }
    }

    private PGStream enableSSL(PGStream pGStream, boolean bl, Properties properties, Logger logger) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" FE=> SSLRequest");
        }
        pGStream.SendInteger4(8);
        pGStream.SendInteger2(1234);
        pGStream.SendInteger2(5679);
        pGStream.flush();
        int n = pGStream.ReceiveChar();
        switch (n) {
            case 69: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLError");
                }
                if (bl) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                pGStream.close();
                return new PGStream(pGStream.getHost(), pGStream.getPort());
            }
            case 78: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLRefused");
                }
                if (bl) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                return pGStream;
            }
            case 83: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLOk");
                }
                Driver.makeSSL(pGStream, properties, logger);
                return pGStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.CONNECTION_FAILURE);
    }

    private void sendStartupPacket(PGStream pGStream, String string, String string2, Logger logger) throws IOException {
        if (logger.logDebug()) {
            logger.debug(" FE=> StartupPacket(user=" + string + ",database=" + string2 + ")");
        }
        pGStream.SendInteger4(296);
        pGStream.SendInteger2(2);
        pGStream.SendInteger2(0);
        pGStream.Send(string2.getBytes("US-ASCII"), 64);
        pGStream.Send(string.getBytes("US-ASCII"), 32);
        pGStream.Send(new byte[64]);
        pGStream.Send(new byte[64]);
        pGStream.Send(new byte[64]);
        pGStream.flush();
    }

    private void doAuthentication(PGStream pGStream, String string, String string2, Logger logger) throws IOException, SQLException {
        block10: while (true) {
            int n = pGStream.ReceiveChar();
            switch (n) {
                case 69: {
                    String string3 = pGStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + string3 + ")");
                    }
                    throw new PSQLException(GT.tr("Connection rejected: {0}.", string3), PSQLState.CONNECTION_REJECTED);
                }
                case 82: {
                    int n2 = pGStream.ReceiveIntegerR(4);
                    switch (n2) {
                        case 4: {
                            Object object = pGStream.ReceiveString(2);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqCrypt(salt='" + (String)object + "')");
                            }
                            if (string2 == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            Object object2 = UnixCrypt.crypt((String)object, string2);
                            byte[] byArray = ((String)object2).getBytes("US-ASCII");
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(crypt='" + (String)object2 + "')");
                            }
                            pGStream.SendInteger4(4 + byArray.length + 1);
                            pGStream.Send(byArray);
                            pGStream.SendChar(0);
                            pGStream.flush();
                            continue block10;
                        }
                        case 5: {
                            Object object = pGStream.Receive(4);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString((byte[])object) + ")");
                            }
                            if (string2 == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            Object object2 = MD5Digest.encode(string, string2, (byte[])object);
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(md5digest=" + new String((byte[])object2, "US-ASCII") + ")");
                            }
                            pGStream.SendInteger4(4 + ((Object)object2).length + 1);
                            pGStream.Send((byte[])object2);
                            pGStream.SendChar(0);
                            pGStream.flush();
                            continue block10;
                        }
                        case 3: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqPassword");
                            }
                            if (string2 == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(password=<not shown>)");
                            }
                            Object object = string2.getBytes("US-ASCII");
                            pGStream.SendInteger4(4 + ((Object)object).length + 1);
                            pGStream.Send((byte[])object);
                            pGStream.SendChar(0);
                            pGStream.flush();
                            continue block10;
                        }
                        case 0: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (logger.logDebug()) {
                        logger.debug(" <=BE AuthenticationReq (unsupported type " + n2 + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(n2)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private void readStartupMessages(PGStream pGStream, ProtocolConnectionImpl protocolConnectionImpl, Logger logger) throws IOException, SQLException {
        block6: while (true) {
            int n = pGStream.ReceiveChar();
            switch (n) {
                case 90: {
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ReadyForQuery");
                    }
                    return;
                }
                case 75: {
                    int n2 = pGStream.ReceiveIntegerR(4);
                    int n3 = pGStream.ReceiveIntegerR(4);
                    if (logger.logDebug()) {
                        logger.debug(" <=BE BackendKeyData(pid=" + n2 + ",ckey=" + n3 + ")");
                    }
                    protocolConnectionImpl.setBackendKeyData(n2, n3);
                    continue block6;
                }
                case 69: {
                    String string = pGStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorResponse(" + string + ")");
                    }
                    throw new PSQLException(GT.tr("Backend start-up failed: {0}.", string), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                case 78: {
                    String string = pGStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE NoticeResponse(" + string + ")");
                    }
                    protocolConnectionImpl.addWarning(new SQLWarning(string));
                    continue block6;
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] runSetupQuery(ProtocolConnectionImpl protocolConnectionImpl, String string, boolean bl) throws SQLException {
        QueryExecutor queryExecutor = protocolConnectionImpl.getQueryExecutor();
        Query query = queryExecutor.createSimpleQuery(string);
        SimpleResultHandler simpleResultHandler = new SimpleResultHandler(protocolConnectionImpl);
        int n = 17;
        if (!bl) {
            n |= 6;
        }
        try {
            queryExecutor.setCurrentStatement(null);
            queryExecutor.execute(query, null, (ResultHandler)simpleResultHandler, 0, 0, n);
        }
        finally {
            query.close();
        }
        if (!bl) {
            return null;
        }
        VectorTuple vectorTuple = simpleResultHandler.getResults();
        if (vectorTuple == null || vectorTuple.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return (byte[][])vectorTuple.elementAt(0);
    }

    private void runInitialQueries(ProtocolConnectionImpl protocolConnectionImpl, String string, Logger logger) throws SQLException, IOException {
        byte[][] byArray = this.runSetupQuery(protocolConnectionImpl, "set datestyle = 'ISO'; select version_internal(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end", true);
        String string2 = protocolConnectionImpl.getEncoding().decode(byArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        protocolConnectionImpl.setServerVersion(string3);
        if (string3.compareTo("7.3") >= 0) {
            if (logger.logDebug()) {
                logger.debug("Switching to UNICODE client_encoding");
            }
            this.runSetupQuery(protocolConnectionImpl, "begin; set autocommit = on; set client_encoding = 'UNICODE'; commit", false);
            protocolConnectionImpl.setEncoding(Encoding.getDatabaseEncoding("UNICODE"));
        } else {
            String string4;
            String string5 = string4 = byArray[1] == null ? null : protocolConnectionImpl.getEncoding().decode(byArray[1]);
            if (logger.logDebug()) {
                logger.debug("Specified charset:  " + string);
                logger.debug("Database encoding: " + string4);
            }
            if (string != null) {
                protocolConnectionImpl.setEncoding(Encoding.getJVMEncoding(string));
            } else if (string4 != null) {
                protocolConnectionImpl.setEncoding(Encoding.getDatabaseEncoding(string4));
            } else {
                protocolConnectionImpl.setEncoding(Encoding.defaultEncoding());
            }
        }
        if (logger.logDebug()) {
            logger.debug("Connection encoding (using JVM's nomenclature): " + protocolConnectionImpl.getEncoding());
        }
    }

    private class SimpleResultHandler
    implements ResultHandler {
        private SQLException error;
        private VectorTuple tuples;
        private final ProtocolConnectionImpl protoConnection;

        SimpleResultHandler(ProtocolConnectionImpl protocolConnectionImpl) {
            this.protoConnection = protocolConnectionImpl;
        }

        VectorTuple getResults() {
            return this.tuples;
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
            this.tuples = vectorTuple;
        }

        public void handleCommandStatus(String string, int n, long l) {
        }

        public void handleWarning(SQLWarning sQLWarning) {
            this.protoConnection.addWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            if (this.error == null) {
                this.error = sQLException;
            } else {
                this.error.setNextException(sQLException);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

