/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v2;

import com.vertica.core.PGStream;
import com.vertica.core.ParameterList;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import com.vertica.util.StreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;

class FastpathParameterList
implements ParameterList {
    private final Object[] paramValues;

    FastpathParameterList(int n) {
        this.paramValues = new Object[n];
    }

    public void registerOutParameter(int n, int n2) {
    }

    public void registerOutParameter(int n, int n2, int n3) {
    }

    public int getInParameterCount() {
        return this.paramValues.length;
    }

    public int getOutParameterCount() {
        return 0;
    }

    public int getParameterCount() {
        return this.paramValues.length;
    }

    public int[] getTypeOIDs() {
        return null;
    }

    public void setIntParameter(int n, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n2;
        byArray[2] = (byte)(n2 >> 8);
        byArray[1] = (byte)(n2 >> 16);
        byArray[0] = (byte)(n2 >> 24);
        this.paramValues[n - 1] = byArray;
    }

    public void setLiteralParameter(int n, String string, int n2) throws SQLException {
        throw new IllegalArgumentException("can't setLiteralParameter() on a fastpath parameter");
    }

    public void setStringParameter(int n, String string, int n2) throws SQLException {
        this.paramValues[n - 1] = string;
    }

    public void setBytea(int n, byte[] byArray, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[n - 1] = new StreamWrapper(byArray, n2, n3);
    }

    public void setBytea(int n, InputStream inputStream, int n2) throws SQLException {
        if (n < 1 || n > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[n - 1] = new StreamWrapper(inputStream, n2);
    }

    public void setNull(int n, int n2) throws SQLException {
        throw new IllegalArgumentException("can't setNull() on a v2 fastpath parameter");
    }

    public String toString(int n) {
        if (n < 1 || n > this.paramValues.length) {
            throw new IllegalArgumentException("parameter " + n + " out of range");
        }
        return "<fastpath parameter>";
    }

    private void copyStream(PGStream pGStream, StreamWrapper streamWrapper) throws IOException {
        byte[] byArray = streamWrapper.getBytes();
        if (byArray != null) {
            pGStream.Send(byArray, streamWrapper.getOffset(), streamWrapper.getLength());
            return;
        }
        pGStream.SendStream(streamWrapper.getStream(), streamWrapper.getLength());
    }

    void writeV2FastpathValue(int n, PGStream pGStream) throws IOException {
        if (this.paramValues[--n] instanceof StreamWrapper) {
            StreamWrapper streamWrapper = (StreamWrapper)this.paramValues[n];
            pGStream.SendInteger4(streamWrapper.getLength());
            this.copyStream(pGStream, streamWrapper);
        } else if (this.paramValues[n] instanceof byte[]) {
            byte[] byArray = (byte[])this.paramValues[n];
            pGStream.SendInteger4(byArray.length);
            pGStream.Send(byArray);
        } else if (this.paramValues[n] instanceof String) {
            byte[] byArray = pGStream.getEncoding().encode((String)this.paramValues[n]);
            pGStream.SendInteger4(byArray.length);
            pGStream.Send(byArray);
        } else {
            throw new IllegalArgumentException("don't know how to stream parameter " + n);
        }
    }

    void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramValues.length; ++i) {
            if (this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    public ParameterList copy() {
        FastpathParameterList fastpathParameterList = new FastpathParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, fastpathParameterList.paramValues, 0, this.paramValues.length);
        return fastpathParameterList;
    }

    public void clear() {
        Arrays.fill(this.paramValues, null);
    }

    public String toBatchString(String string) {
        return null;
    }

    public byte[] toNativeBatchString(boolean bl) {
        return null;
    }

    public int getNativeBufferSize() {
        return 0;
    }
}

