/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.core.ParameterList;
import com.vertica.core.v3.CompositeParameterList;
import com.vertica.core.v3.SimpleParameterList;
import com.vertica.core.v3.SimpleQuery;
import com.vertica.core.v3.V3Query;

class CompositeQuery
implements V3Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] simpleQueryArray, int[] nArray) {
        this.subqueries = simpleQueryArray;
        this.offsets = nArray;
    }

    public ParameterList createParameterList() {
        SimpleParameterList[] simpleParameterListArray = new SimpleParameterList[this.subqueries.length];
        for (int i = 0; i < this.subqueries.length; ++i) {
            simpleParameterListArray[i] = (SimpleParameterList)this.subqueries[i].createParameterList();
        }
        return new CompositeParameterList(simpleParameterListArray, this.offsets);
    }

    public String toString(ParameterList parameterList) {
        StringBuffer stringBuffer = new StringBuffer(this.subqueries[0].toString());
        for (int i = 1; i < this.subqueries.length; ++i) {
            stringBuffer.append(';');
            stringBuffer.append(this.subqueries[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        for (int i = 0; i < this.subqueries.length; ++i) {
            this.subqueries[i].close();
        }
    }

    public SimpleQuery[] getSubqueries() {
        return this.subqueries;
    }

    public boolean isDML() {
        boolean bl = false;
        for (int i = 0; i < this.subqueries.length && !(bl = this.subqueries[i].isDML()); ++i) {
        }
        return bl;
    }
}

