/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.core.ResultCursor;
import com.vertica.core.Utils;
import com.vertica.core.v3.SimpleQuery;
import java.lang.ref.PhantomReference;

class Portal
implements ResultCursor {
    private final SimpleQuery query;
    private final String portalName;
    private final byte[] encodedName;
    private PhantomReference cleanupRef;

    Portal(SimpleQuery simpleQuery, String string) {
        this.query = simpleQuery;
        this.portalName = string;
        this.encodedName = Utils.encodeUTF8(string);
    }

    public void close() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
    }

    String getPortalName() {
        return this.portalName;
    }

    byte[] getEncodedPortalName() {
        return this.encodedName;
    }

    SimpleQuery getQuery() {
        return this.query;
    }

    void setCleanupRef(PhantomReference phantomReference) {
        this.cleanupRef = phantomReference;
    }

    public String toString() {
        return this.portalName;
    }
}

