/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.ds.common;

import com.vertica.ds.PGConnectionPoolDataSource;
import com.vertica.ds.PGPoolingDataSource;
import com.vertica.ds.PGSimpleDataSource;
import com.vertica.ds.common.BaseDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class PGObjectFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        String string = reference.getClassName();
        if (string.equals("com.vertica.ds.PGSimpleDataSource") || string.equals("com.vertica.jdbc2.optional.SimpleDataSource") || string.equals("com.vertica.jdbc3.Jdbc3SimpleDataSource")) {
            return this.loadSimpleDataSource(reference);
        }
        if (string.equals("com.vertica.ds.PGConnectionPoolDataSource") || string.equals("com.vertica.jdbc2.optional.ConnectionPool") || string.equals("com.vertica.jdbc3.Jdbc3ConnectionPool")) {
            return this.loadConnectionPool(reference);
        }
        if (string.equals("com.vertica.ds.PGPoolingDataSource") || string.equals("com.vertica.jdbc2.optional.PoolingDataSource") || string.equals("com.vertica.jdbc3.Jdbc3PoolingDataSource")) {
            return this.loadPoolingDataSource(reference);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference reference) {
        String string;
        String string2 = this.getProperty(reference, "dataSourceName");
        PGPoolingDataSource pGPoolingDataSource = PGPoolingDataSource.getDataSource(string2);
        if (pGPoolingDataSource != null) {
            return pGPoolingDataSource;
        }
        pGPoolingDataSource = new PGPoolingDataSource();
        pGPoolingDataSource.setDataSourceName(string2);
        this.loadBaseDataSource(pGPoolingDataSource, reference);
        String string3 = this.getProperty(reference, "initialConnections");
        if (string3 != null) {
            pGPoolingDataSource.setInitialConnections(Integer.parseInt(string3));
        }
        if ((string = this.getProperty(reference, "maxConnections")) != null) {
            pGPoolingDataSource.setMaxConnections(Integer.parseInt(string));
        }
        return pGPoolingDataSource;
    }

    private Object loadSimpleDataSource(Reference reference) {
        PGSimpleDataSource pGSimpleDataSource = new PGSimpleDataSource();
        return this.loadBaseDataSource(pGSimpleDataSource, reference);
    }

    private Object loadConnectionPool(Reference reference) {
        PGConnectionPoolDataSource pGConnectionPoolDataSource = new PGConnectionPoolDataSource();
        return this.loadBaseDataSource(pGConnectionPoolDataSource, reference);
    }

    protected Object loadBaseDataSource(BaseDataSource baseDataSource, Reference reference) {
        baseDataSource.setDatabaseName(this.getProperty(reference, "databaseName"));
        baseDataSource.setPassword(this.getProperty(reference, "password"));
        String string = this.getProperty(reference, "portNumber");
        if (string != null) {
            baseDataSource.setPortNumber(Integer.parseInt(string));
        }
        baseDataSource.setServerName(this.getProperty(reference, "serverName"));
        baseDataSource.setUser(this.getProperty(reference, "user"));
        String string2 = this.getProperty(reference, "prepareThreshold");
        if (string2 != null) {
            baseDataSource.setPrepareThreshold(Integer.parseInt(string2));
        }
        return baseDataSource;
    }

    protected String getProperty(Reference reference, String string) {
        RefAddr refAddr = reference.get(string);
        if (refAddr == null) {
            return null;
        }
        return (String)refAddr.getContent();
    }
}

