/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.geometric;

import com.vertica.util.GT;
import com.vertica.util.PGobject;
import com.vertica.util.PGtokenizer;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpoint
extends PGobject
implements Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint(double d, double d2) {
        this();
        this.x = d;
        this.y = d2;
    }

    public PGpoint(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGpoint() {
        this.setType("point");
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara(string), ',');
        try {
            this.x = Double.valueOf(pGtokenizer.getToken(0));
            this.y = Double.valueOf(pGtokenizer.getToken(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, string}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)numberFormatException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGpoint) {
            PGpoint pGpoint = (PGpoint)object;
            return this.x == pGpoint.x && this.y == pGpoint.y;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l2 ^ l >>> 32 ^ l2 >>> 32);
    }

    public Object clone() {
        return new PGpoint(this.x, this.y);
    }

    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void move(int n, int n2) {
        this.setLocation(n, n2);
    }

    public void move(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setLocation(int n, int n2) {
        this.move((double)n, (double)n2);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }
}

