/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.PGConnection;
import com.vertica.largeobject.LargeObject;
import com.vertica.largeobject.LargeObjectManager;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class AbstractJdbc2BlobClob {
    private LargeObject lo;

    public AbstractJdbc2BlobClob(PGConnection pGConnection, int n) throws SQLException {
        LargeObjectManager largeObjectManager = pGConnection.getLargeObjectAPI();
        this.lo = largeObjectManager.open(n);
    }

    public long length() throws SQLException {
        return this.lo.size();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        this.assertPosition(l);
        this.lo.seek((int)(l - 1L), 0);
        return this.lo.read(n);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.lo.getInputStream();
    }

    public long position(byte[] byArray, long l) throws SQLException {
        this.assertPosition(l, byArray.length);
        int n = 1;
        int n2 = 0;
        long l2 = -1L;
        int n3 = 1;
        LOIterator lOIterator = new LOIterator(l - 1L);
        while (lOIterator.hasNext()) {
            byte by = lOIterator.next();
            if (by == byArray[n2]) {
                if (n2 == 0) {
                    n3 = n;
                }
                if (++n2 == byArray.length) {
                    l2 = n3;
                    break;
                }
            } else {
                n2 = 0;
            }
            ++n;
        }
        return l2;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    protected LargeObject getLO() {
        return this.lo;
    }

    protected void assertPosition(long l) throws SQLException {
        this.assertPosition(l, 0L);
    }

    protected void assertPosition(long l, long l2) throws SQLException {
        if (l < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (l + l2 - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Vertica Analytic Database LOBs can only index to: {0}", new Integer(Integer.MAX_VALUE)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    private class LOIterator {
        private static final int BUFFER_SIZE = 8096;
        private byte[] buffer = new byte[8096];
        private int idx = 8096;
        private int numBytes = 8096;

        public LOIterator(long l) throws SQLException {
            AbstractJdbc2BlobClob.this.lo.seek((int)l);
        }

        public boolean hasNext() throws SQLException {
            boolean bl = false;
            if (this.idx < this.numBytes) {
                bl = true;
            } else {
                this.numBytes = AbstractJdbc2BlobClob.this.lo.read(this.buffer, 0, 8096);
                this.idx = 0;
                bl = this.numBytes > 0;
            }
            return bl;
        }

        private byte next() {
            return this.buffer[this.idx++];
        }
    }
}

