/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.Driver;
import com.vertica.PGRefCursorResultSet;
import com.vertica.core.BaseConnection;
import com.vertica.core.BaseResultSet;
import com.vertica.core.BaseStatement;
import com.vertica.core.Encoding;
import com.vertica.core.Field;
import com.vertica.core.Query;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.VectorTuple;
import com.vertica.jdbc2.AbstractJdbc2Connection;
import com.vertica.jdbc2.AbstractJdbc2Statement;
import com.vertica.util.ByteConverter;
import com.vertica.util.GT;
import com.vertica.util.PGbytea;
import com.vertica.util.PGobject;
import com.vertica.util.PGtokenizer;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public abstract class AbstractJdbc2ResultSet
implements BaseResultSet,
PGRefCursorResultSet {
    private boolean updateable = false;
    private boolean doingUpdates = false;
    private HashMap updateValues = null;
    private boolean usingOID = false;
    private Vector primaryKeys;
    private boolean singleTable = false;
    private String tableName = null;
    private PreparedStatement updateStatement = null;
    private PreparedStatement insertStatement = null;
    private PreparedStatement deleteStatement = null;
    private PreparedStatement selectStatement = null;
    private int resultsettype;
    private int resultsetconcurrency;
    private int fetchdirection = 1002;
    protected final BaseConnection connection;
    protected final BaseStatement statement;
    protected final Field[] fields;
    protected final Query originalQuery;
    protected final int maxRows;
    protected final int maxFieldSize;
    protected VectorTuple rows;
    protected int current_row = -1;
    protected int row_offset;
    protected byte[][] this_row;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected boolean onInsertRow = false;
    private GregorianCalendar calendar = null;
    public byte[][] rowBuffer = null;
    protected int fetchSize;
    protected ResultCursor cursor;
    private HashMap columnNameIndexMap;
    private boolean ignoreMaxRows = false;
    private String refCursorName;
    private static final BigInteger BYTEMAX = new BigInteger(Byte.toString((byte)127));
    private static final BigInteger BYTEMIN = new BigInteger(Byte.toString((byte)-128));
    private static final BigInteger SHORTMAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger SHORTMIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger LONGMAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger LONGMIN = new BigInteger(Long.toString(Long.MIN_VALUE));

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public AbstractJdbc2ResultSet(Query query, BaseStatement baseStatement, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor, int n, int n2, int n3, int n4) throws SQLException {
        this.originalQuery = query;
        this.connection = (BaseConnection)baseStatement.getConnection();
        this.statement = baseStatement;
        this.fields = fieldArray;
        this.rows = vectorTuple;
        this.cursor = resultCursor;
        this.maxRows = n;
        this.maxFieldSize = n2;
        this.resultsettype = n3;
        this.resultsetconcurrency = n4;
    }

    public URL getURL(int n) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    protected Object internalGetObject(int n, Field field) throws SQLException {
        switch (this.getSQLType(n)) {
            case -7: {
                return this.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(n));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2003: {
                return this.getArray(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
        }
        String string = this.getPGType(n);
        if (string.equals("unknown")) {
            return this.getString(n);
        }
        if (string.equals("refcursor")) {
            String string2 = this.getString(n);
            String string3 = "FETCH ALL IN \"" + string2 + "\"";
            ResultSet resultSet = this.connection.execSQLQuery(string3);
            ((AbstractJdbc2ResultSet)resultSet).setRefCursor(string2);
            return resultSet;
        }
        return null;
    }

    private void checkScrollable() throws SQLException {
        this.checkClosed();
        if (this.resultsettype == 1003) {
            throw new PSQLException(GT.tr("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY."), PSQLState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean absolute(int n) throws SQLException {
        int n2;
        this.checkScrollable();
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        int n3 = this.rows.size();
        if (n < 0) {
            if (n < -n3) {
                this.beforeFirst();
                return false;
            }
            n2 = n3 + n;
        } else {
            if (n > n3) {
                this.afterLast();
                return false;
            }
            n2 = n - 1;
        }
        this.current_row = n2;
        this.this_row = (byte[][])this.rows.elementAt(n2);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        return true;
    }

    public void afterLast() throws SQLException {
        this.checkScrollable();
        int n = this.rows.size();
        if (n > 0) {
            this.current_row = n;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    public void beforeFirst() throws SQLException {
        this.checkScrollable();
        if (this.rows.size() > 0) {
            this.current_row = -1;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    public boolean first() throws SQLException {
        this.checkScrollable();
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = 0;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        return true;
    }

    public java.sql.Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public java.sql.Array getArray(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return this.createArray(n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public abstract Blob getBlob(int var1) throws SQLException;

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (((AbstractJdbc2Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
            return new CharArrayReader(this.getString(n).toCharArray());
        }
        Encoding encoding = this.connection.getEncoding();
        InputStream inputStream = this.getBinaryStream(n);
        try {
            return encoding.getDecodingReader(inputStream);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unexpected error while decoding character data from a large object."), PSQLState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public abstract Clob getClob(int var1) throws SQLException;

    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetconcurrency;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkResultSet(n);
        if (this.isBinary(n)) {
            TimeZone timeZone;
            boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
            if (this.wasNullFlag) {
                return null;
            }
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            TimeZone timeZone2 = timeZone = calendar == null ? null : calendar.getTimeZone();
            if (n3 == 10) {
                return this.connection.getTimestampUtils().toDateBin(timeZone, this.this_row[n2]);
            }
            if (n3 == 12 || n3 == 13) {
                return this.connection.getTimestampUtils().convertToDate(this.getTimestamp(n, calendar), timeZone);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", new Object[]{Integer.toString(n3), "date"}), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
        }
        return this.connection.getTimestampUtils().toDate(calendar, this.getString(n));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkResultSet(n);
        if (this.isBinary(n)) {
            TimeZone timeZone;
            boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
            if (this.wasNullFlag) {
                return null;
            }
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            TimeZone timeZone2 = timeZone = calendar == null ? null : calendar.getTimeZone();
            if (n3 == 11) {
                return this.connection.getTimestampUtils().toTimeBin(timeZone, this.this_row[n2]);
            }
            if (n3 == 15) {
                return this.connection.getTimestampUtils().toTime(calendar, this.getString(n));
            }
            if (n3 == 12 || n3 == 13) {
                return this.connection.getTimestampUtils().convertToTime(this.getTimestamp(n, calendar), timeZone);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", new Object[]{Integer.toString(n3), "time"}), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
        }
        return this.connection.getTimestampUtils().toTime(calendar, this.getString(n));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkResultSet(n);
        if (this.isBinary(n)) {
            long l;
            boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
            if (this.wasNullFlag) {
                return null;
            }
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 13 || n3 == 12) {
                boolean bl2 = n3 == 13;
                TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
                return this.connection.getTimestampUtils().toTimestampBin(timeZone, this.this_row[n2], bl2);
            }
            if (n3 == 11 || n3 == 15) {
                l = this.getTime(n, calendar).getTime();
            } else if (n3 == 10) {
                l = this.getDate(n, calendar).getTime();
            } else {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", new Object[]{Integer.toString(n3), "timestamp"}), PSQLState.DATA_TYPE_MISMATCH);
            }
            return new Timestamp(l);
        }
        if (calendar != null) {
            calendar = (Calendar)calendar.clone();
        }
        return this.connection.getTimestampUtils().toTimestamp(calendar, this.getString(n));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    public Object getObjectImpl(String string, Map map) throws SQLException {
        return this.getObjectImpl(this.findColumn(string), map);
    }

    public Object getObjectImpl(int n, Map map) throws SQLException {
        this.checkClosed();
        if (map == null || map.isEmpty()) {
            return this.getObject(n);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return 0;
        }
        int n = this.rows.size();
        if (this.current_row < 0 || this.current_row >= n) {
            return 0;
        }
        return this.row_offset + this.current_row + 1;
    }

    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    public int getType() throws SQLException {
        this.checkClosed();
        return this.resultsettype;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int n = this.rows.size();
        return this.current_row >= n && n > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.row_offset + this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.row_offset + this.current_row == 0;
    }

    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int n = this.rows.size();
        if (n == 0) {
            return false;
        }
        if (this.current_row != n - 1) {
            return false;
        }
        if (this.cursor == null) {
            return true;
        }
        if (this.maxRows > 0 && this.row_offset + this.current_row == this.maxRows) {
            return true;
        }
        this.row_offset += n - 1;
        int n2 = this.fetchSize;
        if (this.maxRows != 0 && (n2 == 0 || this.row_offset + n2 > this.maxRows)) {
            n2 = this.maxRows - this.row_offset;
        }
        this.connection.getQueryExecutor().fetchLRS(this.cursor, new CursorResultHandler());
        this.rows.insertElementAt(this.this_row, 0);
        this.current_row = 0;
        return this.rows.size() == 1;
    }

    public boolean last() throws SQLException {
        this.checkClosed();
        int n = this.rows.size();
        if (n <= 0) {
            return false;
        }
        if (this.connection.isInLRS() && this.connection.getQueryExecutor().getCurrentStatement() == this.statement) {
            while (!this.isLast()) {
                this.next();
            }
            return this.isLast();
        }
        this.current_row = n - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        return true;
    }

    public boolean previous() throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row - 1 < 0) {
            this.current_row = -1;
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        --this.current_row;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean relative(int n) throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        return this.absolute(this.current_row + 1 + n);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", new Integer(n)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchdirection = n;
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call cancelRowUpdates() when on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    public synchronized void deleteRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call deleteRow() when on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst()) {
            throw new PSQLException(GT.tr("Currently positioned before the start of the ResultSet.  You cannot call deleteRow() here."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isAfterLast()) {
            throw new PSQLException(GT.tr("Currently positioned after the end of the ResultSet.  You cannot call deleteRow() here."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.rows.size() == 0) {
            throw new PSQLException(GT.tr("There are no rows in this ResultSet."), PSQLState.INVALID_CURSOR_STATE);
        }
        int n = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM ").append(this.tableName).append(" where ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\"");
                stringBuffer.append(((PrimaryKey)this.primaryKeys.get((int)i)).name);
                stringBuffer.append("\" = ?");
                if (i >= n - 1) continue;
                stringBuffer.append(" and ");
            }
            this.deleteStatement = this.connection.prepareStatement(stringBuffer.toString());
        }
        this.deleteStatement.clearParameters();
        for (int i = 0; i < n; ++i) {
            this.deleteStatement.setObject(i + 1, ((PrimaryKey)this.primaryKeys.get(i)).getValue());
        }
        this.deleteStatement.executeUpdate();
        this.rows.removeElementAt(this.current_row);
        --this.current_row;
        this.moveToCurrentRow();
    }

    public synchronized void insertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new PSQLException(GT.tr("Not on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues.size() == 0) {
            throw new PSQLException(GT.tr("You must specify at least one column value to insert a row."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ").append(this.tableName).append(" (");
        StringBuffer stringBuffer2 = new StringBuffer(") values (");
        Iterator iterator = this.updateValues.keySet().iterator();
        int n = this.updateValues.size();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
            if (n2 < n - 1) {
                stringBuffer.append(", ");
                stringBuffer2.append("?,");
            } else {
                stringBuffer2.append("?)");
            }
            ++n2;
        }
        stringBuffer.append(stringBuffer2.toString());
        this.insertStatement = this.connection.prepareStatement(stringBuffer.toString());
        Iterator iterator2 = this.updateValues.keySet().iterator();
        int n3 = 1;
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            Object v = this.updateValues.get(string);
            this.insertStatement.setObject(n3, v);
            ++n3;
        }
        this.insertStatement.executeUpdate();
        if (this.usingOID) {
            long l = ((AbstractJdbc2Statement)((Object)this.insertStatement)).getLastOID();
            this.updateValues.put("oid", new Long(l));
        }
        this.updateRowBuffer();
        this.rows.addElement(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.clearRowBuffer(false);
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkUpdateable();
        if (this.current_row < 0 || this.current_row >= this.rows.size()) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdateable();
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer(false);
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer(boolean bl) throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        if (bl) {
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.updateValues.clear();
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
            return;
        }
        try {
            int n3;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "ASCII");
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = inputStreamReader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.updateString(n, new String(cArray, 0, n4));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), null, (Throwable)iOException);
        }
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
            return;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            int n4;
            while ((n4 = inputStream.read(byArray, n3, n2 - n3)) != -1 && (n3 += n4) != n2) {
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), null, (Throwable)iOException);
        }
        if (n3 == n2) {
            this.updateBytes(n, byArray);
        } else {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            this.updateBytes(n, byArray2);
        }
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateValue(n, new Boolean(bl));
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, String.valueOf(by));
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
            return;
        }
        try {
            int n3;
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = reader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.updateString(n, new String(cArray, 0, n4));
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided Reader failed."), null, (Throwable)iOException);
        }
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, date);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.updateValue(n, new Double(d));
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.updateValue(n, new Float(f));
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.updateValue(n, new Integer(n2));
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        this.updateValue(n, new Long(l));
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.checkColumnIndex(n);
        String string = this.connection.getPGType(this.fields[n - 1].getOID());
        this.updateValue(n, new NullObject(string));
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.updateValue(n, object);
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void refreshRow() throws SQLException {
        int n;
        int n2;
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t refresh the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("select ");
        int n3 = Array.getLength(this.fields);
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(this.fields[n2].getColumnLabel());
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" from ").append(this.tableName).append(" where ");
        n2 = this.primaryKeys.size();
        for (n = 0; n < n2; ++n) {
            PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(n);
            stringBuffer.append(primaryKey.name).append("= ?");
            if (n >= n2 - 1) continue;
            stringBuffer.append(" and ");
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("selecting " + stringBuffer.toString());
        }
        this.selectStatement = this.connection.prepareStatement(stringBuffer.toString());
        n = 0;
        int n4 = 1;
        while (n < n2) {
            this.selectStatement.setObject(n4, ((PrimaryKey)this.primaryKeys.get(n)).getValue());
            ++n;
            ++n4;
        }
        AbstractJdbc2ResultSet abstractJdbc2ResultSet = (AbstractJdbc2ResultSet)this.selectStatement.executeQuery();
        if (abstractJdbc2ResultSet.next()) {
            this.rowBuffer = abstractJdbc2ResultSet.rowBuffer;
        }
        this.rows.setElementAt(this.rowBuffer, this.current_row);
        this.this_row = this.rowBuffer;
        this.connection.getLogger().debug("done updates");
        abstractJdbc2ResultSet.close();
        this.selectStatement.close();
        this.selectStatement = null;
        this.cancelRowUpdates();
    }

    public synchronized void updateRow() throws SQLException {
        int n;
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call updateRow() when on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.size() == 0) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (!this.doingUpdates) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.tableName + " SET  ");
        int n2 = this.updateValues.size();
        Iterator iterator = this.updateValues.keySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\" = ?");
            if (n3 < n2 - 1) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append(" WHERE ");
        n3 = this.primaryKeys.size();
        for (n = 0; n < n3; ++n) {
            PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(n);
            stringBuffer.append("\"");
            stringBuffer.append(primaryKey.name);
            stringBuffer.append("\" = ?");
            if (n >= n3 - 1) continue;
            stringBuffer.append(" and ");
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("updating " + stringBuffer.toString());
        }
        this.updateStatement = this.connection.prepareStatement(stringBuffer.toString());
        n = 0;
        for (Object e : this.updateValues.values()) {
            this.updateStatement.setObject(n + 1, e);
            ++n;
        }
        int n4 = 0;
        while (n4 < n3) {
            this.updateStatement.setObject(n + 1, ((PrimaryKey)this.primaryKeys.get(n4)).getValue());
            ++n4;
            ++n;
        }
        this.updateStatement.executeUpdate();
        this.updateStatement.close();
        this.updateStatement = null;
        this.updateRowBuffer();
        this.connection.getLogger().debug("copying data");
        System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
        this.rows.setElementAt(this.rowBuffer, this.current_row);
        this.connection.getLogger().debug("done updates");
        this.updateValues.clear();
        this.doingUpdates = false;
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        this.updateValue(n, new Short(s));
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        this.updateValue(n, string);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.updateValue(n, time);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateValue(n, timestamp);
    }

    public synchronized void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    boolean isUpdateable() throws SQLException {
        this.checkClosed();
        if (this.resultsetconcurrency == 1007) {
            throw new PSQLException(GT.tr("ResultSets with concurrency CONCUR_READ_ONLY cannot be updated."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateable) {
            return true;
        }
        if (this.connection.isInLRS()) {
            return false;
        }
        this.connection.getLogger().debug("checking if rs is updateable");
        this.parseQuery();
        if (!this.singleTable) {
            this.connection.getLogger().debug("not a single table");
            return false;
        }
        this.connection.getLogger().debug("getting primary keys");
        this.primaryKeys = new Vector();
        this.usingOID = false;
        int n = this.findColumnIndex("oid");
        int n2 = 0;
        if (n > 0) {
            ++n2;
            this.primaryKeys.add(new PrimaryKey(n, "oid"));
            this.usingOID = true;
        } else {
            String[] stringArray = AbstractJdbc2ResultSet.quotelessTableName(this.tableName);
            String string = stringArray[0];
            String string2 = stringArray[1];
            ResultSet resultSet = this.connection.getMetaData().getPrimaryKeys("", string2, string);
            while (resultSet.next()) {
                String string3 = resultSet.getString(4);
                int n3 = this.findColumn(string3);
                if (n3 > 0) {
                    this.primaryKeys.add(new PrimaryKey(n3, string3));
                }
                ++n2;
            }
            resultSet.close();
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("no of keys=" + n2);
        }
        if (n2 < 1) {
            throw new PSQLException(GT.tr("No primary key found for table {0}.", this.tableName), PSQLState.DATA_ERROR);
        }
        boolean bl = this.updateable = this.primaryKeys.size() > 0;
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("checking primary key " + this.updateable);
        }
        return this.updateable;
    }

    public static String[] quotelessTableName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String[] stringArray = new String[]{null, ""};
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < stringBuffer.length() - 1 && stringBuffer.charAt(i + 1) == '\"') {
                        ++i;
                        stringBuffer2.append(c);
                        continue block4;
                    }
                    bl = !bl;
                    continue block4;
                }
                case '.': {
                    if (bl) {
                        stringBuffer2.append(c);
                        continue block4;
                    }
                    stringArray[1] = stringBuffer2.toString();
                    stringBuffer2 = new StringBuffer();
                    continue block4;
                }
                default: {
                    stringBuffer2.append(bl ? c : Character.toLowerCase(c));
                }
            }
        }
        stringArray[0] = stringBuffer2.toString();
        return stringArray;
    }

    private void parseQuery() {
        String string = this.originalQuery.toString(null);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \r\t\n");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        this.singleTable = true;
        while (!bl && !bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!bl) {
                if (!string2.toLowerCase().equals("from")) continue;
                this.tableName = stringTokenizer.nextToken();
                this.tableName = this.tableName.replace(";", "");
                bl = true;
                continue;
            }
            bl2 = true;
            this.singleTable = !string2.equalsIgnoreCase(",");
        }
    }

    private void updateRowBuffer() throws SQLException {
        block7: for (String string : this.updateValues.keySet()) {
            int n = this.findColumn(string) - 1;
            Object v = this.updateValues.get(string);
            if (v instanceof NullObject) {
                this.rowBuffer[n] = null;
                continue;
            }
            switch (this.getSQLType(n + 1)) {
                case -7: 
                case -6: 
                case -5: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 1111: {
                    this.rowBuffer[n] = this.connection.encodeString(String.valueOf(v));
                    continue block7;
                }
                case 91: {
                    this.rowBuffer[n] = this.connection.encodeString(this.connection.getTimestampUtils().toString(null, (Date)v));
                    continue block7;
                }
                case 92: {
                    this.rowBuffer[n] = this.connection.encodeString(this.connection.getTimestampUtils().toString(null, (Time)v));
                    continue block7;
                }
                case 93: {
                    this.rowBuffer[n] = this.connection.encodeString(this.connection.getTimestampUtils().toString(null, (Timestamp)v));
                    continue block7;
                }
                case 0: {
                    continue block7;
                }
            }
            this.rowBuffer[n] = (byte[])v;
        }
    }

    public BaseStatement getPGStatement() {
        return this.statement;
    }

    public String getRefCursor() {
        return this.refCursorName;
    }

    private void setRefCursor(String string) {
        this.refCursorName = string;
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.maxRows > 0 && this.current_row + 1 == this.maxRows && !this.ignoreMaxRows) {
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        if (this.current_row + 1 >= this.rows.size()) {
            if (this.cursor == null || this.maxRows > 0 && this.row_offset + this.rows.size() >= this.maxRows && !this.ignoreMaxRows) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.row_offset += this.rows.size();
            int n = this.fetchSize;
            if (this.maxRows != 0 && (n == 0 || this.row_offset + n > this.maxRows)) {
                n = this.maxRows - this.row_offset;
            }
            this.connection.getQueryExecutor().fetchLRS(this.cursor, new CursorResultHandler());
            this.current_row = 0;
            if (this.rows == null || this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        } else {
            ++this.current_row;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public void close() throws SQLException {
        if (this.connection.isInLRS() && this.connection.getQueryExecutor().getCurrentStatement() == this.statement) {
            try {
                this.statement.cancel();
                this.ignoreMaxRows = true;
                while (this.next()) {
                }
            }
            catch (PSQLException pSQLException) {
                // empty catch block
            }
            this.ignoreMaxRows = false;
            this.statement.clearWarnings();
            this.connection.setInLRS(false);
        }
        this.rows = null;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullFlag;
    }

    public String getString(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.isBinary(n)) {
            switch (this.fields[n - 1].getOID()) {
                case 6: {
                    return Long.valueOf(ByteConverter.int8(this.this_row[n - 1], 0)).toString();
                }
                case 7: {
                    return Double.valueOf(ByteConverter.float8(this.this_row[n - 1], 0)).toString();
                }
                case 10: {
                    return this.getDate(n).toString();
                }
                case 11: {
                    return this.getTime(n).toString();
                }
                case 12: {
                    return this.getTimestamp(n).toString();
                }
                case 5: {
                    return Boolean.valueOf(this.getBoolean(n)).toString();
                }
            }
        }
        Encoding encoding = this.connection.getEncoding();
        try {
            return this.trimString(n, encoding.decode(this.this_row[n - 1]));
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database."), PSQLState.DATA_ERROR, (Throwable)iOException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.isBinary(n)) {
            boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
            if (this.wasNullFlag) {
                return false;
            }
            return this.this_row[n - 1][0] == 1;
        }
        return AbstractJdbc2ResultSet.toBoolean(this.getString(n));
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getLong(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getLong(n);
    }

    public int getInt(int n) throws SQLException {
        return (int)this.getLong(n);
    }

    public long getLong(int n) throws SQLException {
        if (this.isBinary(n) && (this.fields[n - 1].getOID() == 7 || this.fields[n - 1].getOID() == 6)) {
            boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
            if (this.wasNullFlag) {
                return 0L;
            }
            long l = 0L;
            if (this.fields[n - 1].getOID() == 7) {
                l = (long)ByteConverter.float8(this.this_row[n - 1], 0);
            } else if (this.fields[n - 1].getOID() == 6) {
                l = ByteConverter.int8(this.this_row[n - 1], 0);
            }
            return l;
        }
        return AbstractJdbc2ResultSet.toLong(this.getFixedString(n));
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public double getDouble(int n) throws SQLException {
        if (this.isBinary(n) && (this.fields[n - 1].getOID() == 7 || this.fields[n - 1].getOID() == 6)) {
            boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
            if (this.wasNullFlag) {
                return 0.0;
            }
            double d = 0.0;
            if (this.fields[n - 1].getOID() == 7) {
                d = ByteConverter.float8(this.this_row[n - 1], 0);
            } else if (this.fields[n - 1].getOID() == 6) {
                d = ByteConverter.int8(this.this_row[n - 1], 0);
            }
            return d;
        }
        return AbstractJdbc2ResultSet.toDouble(this.getFixedString(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return AbstractJdbc2ResultSet.toBigDecimal(this.getFixedString(n), n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (!this.wasNullFlag) {
            if (this.fields[n - 1].getFormat() == 1) {
                return this.this_row[n - 1];
            }
            if (this.fields[n - 1].getOID() == 117 || this.fields[n - 1].getOID() == 17) {
                return this.trimBytes(n, PGbytea.toBytes(this.this_row[n - 1]));
            }
            return this.trimBytes(n, this.this_row[n - 1]);
        }
        return null;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(n).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)unsupportedEncodingException);
            }
        }
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(n).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "UTF-8"), PSQLState.UNEXPECTED_ERROR, (Throwable)unsupportedEncodingException);
            }
        }
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), null);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public Object getObject(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[n - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        Object object = this.internalGetObject(n, field);
        if (object != null) {
            return object;
        }
        return this.connection.getObject(this.getPGType(n), this.getString(n));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        this.checkClosed();
        int n = this.findColumnIndex(string);
        if (n == 0) {
            throw new PSQLException(GT.tr("The column name {0} was not found in this ResultSet.", string), PSQLState.UNDEFINED_COLUMN);
        }
        return n;
    }

    private int findColumnIndex(String string) {
        Integer n;
        if (this.columnNameIndexMap == null) {
            this.columnNameIndexMap = new HashMap(this.fields.length * 2);
            for (int i = 0; i < this.fields.length; ++i) {
                this.columnNameIndexMap.put(this.fields[i].getColumnLabel().toLowerCase(), new Integer(i + 1));
            }
        }
        if ((n = (Integer)this.columnNameIndexMap.get(string)) != null) {
            return n;
        }
        n = (Integer)this.columnNameIndexMap.get(string.toLowerCase());
        if (n != null) {
            this.columnNameIndexMap.put(string, n);
            return n;
        }
        return 0;
    }

    public int getColumnOID(int n) {
        return this.fields[n - 1].getOID();
    }

    public String getFixedString(int n) throws SQLException {
        String string = this.getString(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        if (c == '(') {
            string = "-" + PGtokenizer.removePara(string).substring(1);
        }
        if (c == '$') {
            string = string.substring(1);
        } else if (c == '-' && string.charAt(1) == '$') {
            string = "-" + string.substring(2);
        }
        return string;
    }

    protected String getPGType(int n) throws SQLException {
        return this.connection.getPGType(this.fields[n - 1].getOID());
    }

    protected int getSQLType(int n) throws SQLException {
        return this.connection.getSQLType(this.fields[n - 1].getOID());
    }

    private void checkUpdateable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdateable()) {
            throw new PSQLException(GT.tr("ResultSet is not updateable.  The query that generated this result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException(GT.tr("This ResultSet is closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    protected void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.fields.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkResultSet(int n) throws SQLException {
        this.checkClosed();
        if (this.this_row == null) {
            throw new PSQLException(GT.tr("ResultSet not positioned properly, perhaps you need to call next."), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(n);
    }

    protected boolean isBinary(int n) {
        return this.fields[n - 1].getFormat() == 1;
    }

    public static boolean toBoolean(String string) {
        if (string != null) {
            if ((string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
                return true;
            }
            try {
                if (Double.valueOf(string) == 1.0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int toInt(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    int n = bigInteger.compareTo(INTMAX);
                    int n2 = bigInteger.compareTo(INTMIN);
                    if (n > 0 || n2 < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"int", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return bigInteger.intValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"int", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static long toLong(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    int n = bigInteger.compareTo(LONGMAX);
                    int n2 = bigInteger.compareTo(LONGMIN);
                    if (n > 0 || n2 < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"long", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return bigInteger.longValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"long", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0L;
    }

    public static BigDecimal toBigDecimal(String string, int n) throws SQLException {
        if (string != null) {
            BigDecimal bigDecimal;
            try {
                string = string.trim();
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"BigDecimal", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
            if (n == -1) {
                return bigDecimal;
            }
            try {
                return bigDecimal.setScale(n);
            }
            catch (ArithmeticException arithmeticException) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"BigDecimal", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return null;
    }

    public static float toFloat(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"float", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String string) throws SQLException {
        if (string != null) {
            try {
                string = string.trim();
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"double", string}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0;
    }

    private boolean isColumnTrimmable(int n) throws SQLException {
        switch (this.getSQLType(n)) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(int n, byte[] byArray) throws SQLException {
        if (this.maxFieldSize > 0 && byArray.length > this.maxFieldSize && this.isColumnTrimmable(n)) {
            byte[] byArray2 = new byte[this.maxFieldSize];
            System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
            return byArray2;
        }
        return byArray;
    }

    private String trimString(int n, String string) throws SQLException {
        if (this.maxFieldSize > 0 && string.length() > this.maxFieldSize && this.isColumnTrimmable(n)) {
            return string.substring(0, this.maxFieldSize);
        }
        return string;
    }

    protected void updateValue(int n, Object object) throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || this.rows.size() == 0)) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results."), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(n);
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (object == null) {
            this.updateNull(n);
        } else {
            this.updateValues.put(this.fields[n - 1].getColumnLabel(), object);
        }
    }

    public void ignoreMaxRows(boolean bl) {
        this.ignoreMaxRows = bl;
    }

    class NullObject
    extends PGobject {
        NullObject(String string) {
            this.setType(string);
        }

        public String getValue() {
            return null;
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int n, String string) {
            this.index = n;
            this.name = string;
        }

        Object getValue() throws SQLException {
            return AbstractJdbc2ResultSet.this.getObject(this.index);
        }
    }

    public class CursorResultHandler
    implements ResultHandler {
        private SQLException error;

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
            AbstractJdbc2ResultSet.this.rows = vectorTuple;
            AbstractJdbc2ResultSet.this.cursor = resultCursor;
        }

        public void handleCommandStatus(String string, int n, long l) {
            this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", string), PSQLState.PROTOCOL_VIOLATION));
        }

        public void handleWarning(SQLWarning sQLWarning) {
            AbstractJdbc2ResultSet.this.addWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            if (this.error == null) {
                this.error = sQLException;
            } else {
                this.error.setNextException(sQLException);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

