/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.PGResultSetMetaData;
import com.vertica.core.BaseConnection;
import com.vertica.core.Field;
import com.vertica.jdbc2.TypeInfoCache;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.SQLException;
import java.util.Hashtable;

public abstract class AbstractJdbc2ResultSetMetaData
implements PGResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private Hashtable tableNameCache;
    private Hashtable schemaNameCache;

    public AbstractJdbc2ResultSetMetaData(BaseConnection baseConnection, Field[] fieldArray) {
        this.connection = baseConnection;
        this.fields = fieldArray;
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getAutoIncrement(this.connection);
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        Field field = this.getField(n);
        return TypeInfoCache.isCaseSensitive(field.getOID());
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        String string = this.getPGType(n);
        return string.equals("cash") || string.equals("money");
    }

    public int isNullable(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getNullable(this.connection);
    }

    public boolean isSigned(int n) throws SQLException {
        Field field = this.getField(n);
        return TypeInfoCache.isSigned(field.getOID());
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        Field field = this.getField(n);
        return TypeInfoCache.getDisplaySize(field.getOID(), field.getMod());
    }

    public String getColumnLabel(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getColumnLabel();
    }

    public String getColumnName(int n) throws SQLException {
        return this.getColumnLabel(n);
    }

    public String getBaseColumnName(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getColumnName(this.connection);
    }

    public String getSchemaName(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getSchemaName();
    }

    public int getPrecision(int n) throws SQLException {
        Field field = this.getField(n);
        int n2 = field.getMod();
        switch (field.getOID()) {
            case 8: 
            case 9: 
            case 17: 
            case 117: {
                if (n2 == -1) {
                    n2 = 80;
                    break;
                }
                n2 -= 4;
                break;
            }
        }
        return TypeInfoCache.getPrecision(field.getOID(), n2);
    }

    public int getScale(int n) throws SQLException {
        Field field = this.getField(n);
        return TypeInfoCache.getScale(field.getOID(), field.getMod());
    }

    public String getTableName(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getTableName();
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        return this.getSQLType(n);
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.getPGType(n);
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    protected Field getField(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.fields.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[n - 1];
    }

    protected String getPGType(int n) throws SQLException {
        return this.connection.getPGType(this.getField(n).getOID());
    }

    protected int getSQLType(int n) throws SQLException {
        return this.connection.getSQLType(this.getField(n).getOID());
    }

    public String getColumnClassName(int n) throws SQLException {
        Field field = this.getField(n);
        String string = this.connection.getJavaClass(field.getOID());
        if (string != null) {
            return string;
        }
        int n2 = this.getSQLType(n);
        switch (n2) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String string2 = this.getPGType(n);
        if ("unknown".equals(string2)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }
}

