/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc3;

import com.vertica.jdbc2.AbstractJdbc2Connection;
import com.vertica.jdbc3.PSQLSavepoint;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;

public abstract class AbstractJdbc3Connection
extends AbstractJdbc2Connection {
    private int rsHoldability = 2;
    private int savepointId = 0;

    protected AbstractJdbc3Connection(String string, int n, String string2, String string3, Properties properties, String string4) throws SQLException {
        super(string, n, string2, string3, properties, string4);
    }

    public void setHoldability(int n) throws SQLException {
        switch (n) {
            case 2: {
                this.rsHoldability = n;
                break;
            }
            case 1: {
                this.rsHoldability = n;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", new Integer(n)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    public int getHoldability() throws SQLException {
        return this.rsHoldability;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint pSQLSavepoint = new PSQLSavepoint(this.savepointId++);
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT " + pSQLSavepoint.getPGName());
        statement.close();
        return pSQLSavepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint pSQLSavepoint = new PSQLSavepoint(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT " + pSQLSavepoint.getPGName());
        statement.close();
        return pSQLSavepoint;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        PSQLSavepoint pSQLSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pSQLSavepoint.getPGName());
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        PSQLSavepoint pSQLSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pSQLSavepoint.getPGName());
        pSQLSavepoint.invalidate();
    }

    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.getHoldability());
    }

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.getHoldability());
    }

    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.getHoldability());
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n != 2) {
            throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
        }
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (nArray.length != 0) {
            throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
        }
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (stringArray.length != 0) {
            throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
        }
        return this.prepareStatement(string);
    }
}

