/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc3;

import com.vertica.Driver;
import com.vertica.core.Field;
import com.vertica.core.Query;
import com.vertica.core.ResultHandler;
import com.vertica.core.VectorTuple;
import com.vertica.jdbc2.AbstractJdbc2Statement;
import com.vertica.jdbc3.AbstractJdbc3Connection;
import com.vertica.jdbc3.PSQLParameterMetaData;
import com.vertica.util.GT;
import com.vertica.util.IOStream;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class AbstractJdbc3Statement
extends AbstractJdbc2Statement {
    private final int rsHoldability;

    public AbstractJdbc3Statement(AbstractJdbc3Connection abstractJdbc3Connection, int n, int n2, int n3) throws SQLException {
        super(abstractJdbc3Connection, n, n2);
        this.rsHoldability = n3;
    }

    public AbstractJdbc3Statement(AbstractJdbc3Connection abstractJdbc3Connection, String string, boolean bl, int n, int n2, int n3) throws SQLException {
        super(abstractJdbc3Connection, string, bl, n, n2);
        this.rsHoldability = n3;
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (n == 1 && this.result != null && this.result.getResultSet() != null) {
            this.result.getResultSet().close();
        }
        if (this.result != null) {
            this.result = this.result.getNext();
        }
        if (n == 3) {
            while (this.firstUnclosedResult != this.result) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createDriverResultSet(new Field[0], new VectorTuple(this.connection.getLogger()));
    }

    public int executeUpdate(String string, int n) throws SQLException {
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.executeUpdate(string);
    }

    public boolean execute(String string, int n) throws SQLException {
        return this.execute(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.execute(string);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.execute(string);
    }

    public boolean executeCopyIn(String string, InputStream inputStream) throws SQLException {
        this.clearAcceptedRejectedRows();
        if (!string.toUpperCase().startsWith("COPY ")) {
            throw new PSQLException(GT.tr("Expected COPY command"), PSQLState.SYNTAX_ERROR);
        }
        if (inputStream == null) {
            throw new PSQLException(GT.tr("Expecting input stream for COPY"), PSQLState.COMMUNICATION_ERROR);
        }
        this.checkClosed();
        Query query = this.connection.getQueryExecutor().createSimpleQuery(string);
        IOStream iOStream = new IOStream(inputStream);
        this.executeWithStream(query, iOStream, 4);
        this.lastSimpleQuery = query;
        return this.result != null && this.result.getResultSet() != null;
    }

    public boolean executeCopyOut(String string, OutputStream outputStream) throws SQLException {
        if (!string.toUpperCase().startsWith("COPY ")) {
            throw new PSQLException(GT.tr("Expected COPY command"), PSQLState.SYNTAX_ERROR);
        }
        this.checkClosed();
        Query query = this.connection.getQueryExecutor().createSimpleQuery(string);
        IOStream iOStream = new IOStream(outputStream);
        this.executeWithStream(query, iOStream, 0);
        this.lastSimpleQuery = query;
        return this.result != null && this.result.getResultSet() != null;
    }

    public void startCopyIn(String string, InputStream inputStream) throws SQLException {
        this.clearAcceptedRejectedRows();
        if (!string.toUpperCase().startsWith("COPY ")) {
            throw new PSQLException(GT.tr("Expected COPY command"), PSQLState.SYNTAX_ERROR);
        }
        if (inputStream == null) {
            throw new PSQLException(GT.tr("Expecting input stream for COPY"), PSQLState.COMMUNICATION_ERROR);
        }
        this.checkClosed();
        Query query = this.connection.getQueryExecutor().createSimpleQuery(string);
        IOStream iOStream = new IOStream(inputStream);
        this.executeWithStream(query, iOStream, 68);
        this.connection.setInCopyIn(true);
        this.lastSimpleQuery = query;
    }

    public void addStreamToCopyIn(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            return;
        }
        IOStream iOStream = new IOStream(inputStream);
        this.executeWithStream(null, iOStream, 132);
    }

    public void finishCopyIn() throws SQLException {
        this.executeWithStream(null, null, 260);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        int n = 49;
        AbstractJdbc2Statement.StatementResultHandler statementResultHandler = new AbstractJdbc2Statement.StatementResultHandler();
        this.connection.getQueryExecutor().setCurrentStatement(this);
        this.connection.getQueryExecutor().execute(this.preparedQuery, this.preparedParameters, (ResultHandler)statementResultHandler, 0, 0, n);
        int[] nArray = this.preparedParameters.getTypeOIDs();
        if (nArray != null) {
            return new PSQLParameterMetaData(this.connection, nArray);
        }
        return null;
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int)");
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,int)");
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,String)");
    }

    public URL getURL(int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(String,URL)");
    }

    public void setNull(String string, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int)");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBoolean(String,boolean)");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setByte(String,byte)");
    }

    public void setShort(String string, short s) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setShort(String,short)");
    }

    public void setInt(String string, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setInt(String,int)");
    }

    public void setLong(String string, long l) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLong(String,long)");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setFloat(String,float)");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDouble(String,double)");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBigDecimal(String,BigDecimal)");
    }

    public void setString(String string, String string2) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setString(String,String)");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(String,byte)");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date)");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time)");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp)");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String,InputStream,int)");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String,InputStream,int)");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int,int)");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int)");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object)");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date,Calendar)");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time,Calendar)");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp,Calendar)");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    public String getString(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getString(String)");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBoolean(String)");
    }

    public byte getByte(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getByte(String)");
    }

    public short getShort(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getShort(String)");
    }

    public int getInt(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getInt(String)");
    }

    public long getLong(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLong(String)");
    }

    public float getFloat(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFloat(String)");
    }

    public double getDouble(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDouble(String)");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBytes(String)");
    }

    public Date getDate(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String)");
    }

    public Time getTime(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String)");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String)");
    }

    public Object getObject(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String)");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBigDecimal(String)");
    }

    public Object getObjectImpl(String string, Map map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String,Map)");
    }

    public Ref getRef(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    public Blob getBlob(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    public Clob getClob(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(String)");
    }

    public Array getArray(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String,Calendar)");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String,Calendar)");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String,Calendar)");
    }

    public URL getURL(String string) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (n2 == 16) {
            n2 = -7;
        }
        super.setObject(n, object, n2, n3);
    }

    public void setNull(int n, int n2) throws SQLException {
        if (n2 == 16) {
            n2 = -7;
        }
        super.setNull(n, n2);
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        switch (n2) {
            case 16: {
                n2 = -7;
                break;
            }
        }
        super.registerOutParameter(n, n2, !this.adjustIndex);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }
}

