/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.largeobject;

import com.vertica.core.BaseConnection;
import com.vertica.fastpath.Fastpath;
import com.vertica.fastpath.FastpathArg;
import com.vertica.largeobject.LargeObject;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LargeObjectManager {
    private Fastpath fp;
    private BaseConnection conn;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
    }

    public LargeObjectManager(BaseConnection baseConnection) throws SQLException {
        ResultSet resultSet;
        this.conn = baseConnection;
        this.fp = baseConnection.getFastpathAPI();
        String string = baseConnection.getMetaData().supportsSchemasInTableDefinitions() ? "SELECT p.proname,p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n  WHERE p.pronamespace=n.oid AND n.nspname='pg_catalog' AND (" : "SELECT proname,oid FROM pg_proc WHERE ";
        string = string + " proname = 'lo_open' or proname = 'lo_close' or proname = 'lo_creat' or proname = 'lo_unlink' or proname = 'lo_lseek' or proname = 'lo_tell' or proname = 'loread' or proname = 'lowrite'";
        if (baseConnection.getMetaData().supportsSchemasInTableDefinitions()) {
            string = string + ")";
        }
        if ((resultSet = baseConnection.createStatement().executeQuery(string)) == null) {
            throw new PSQLException(GT.tr("Failed to initialize LargeObject API"), PSQLState.SYSTEM_ERROR);
        }
        this.fp.addFunctions(resultSet);
        resultSet.close();
        baseConnection.getLogger().debug("Large Object initialised");
    }

    public LargeObject open(int n) throws SQLException {
        return this.open(n, 393216);
    }

    public LargeObject open(int n, int n2) throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return new LargeObject(this.fp, n, n2);
    }

    public int create() throws SQLException {
        return this.create(393216);
    }

    public int create(int n) throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n)};
        return this.fp.getInteger("lo_creat", fastpathArgArray);
    }

    public void delete(int n) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n)};
        this.fp.fastpath("lo_unlink", false, fastpathArgArray);
    }

    public void unlink(int n) throws SQLException {
        this.delete(n);
    }
}

