/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.xa;

import com.vertica.core.BaseConnection;
import com.vertica.core.Logger;
import com.vertica.ds.common.PooledConnectionImpl;
import com.vertica.util.GT;
import com.vertica.xa.PGXAException;
import com.vertica.xa.RecoveredXid;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class PGXAConnection
extends PooledConnectionImpl
implements XAConnection,
XAResource {
    private final BaseConnection conn;
    private final Logger logger;
    private Xid currentXid;
    private int state;
    private static final int STATE_IDLE = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_ENDED = 2;

    private void debug(String string) {
        this.logger.debug("XAResource " + Integer.toHexString(this.hashCode()) + ": " + string);
    }

    PGXAConnection(BaseConnection baseConnection) throws SQLException {
        super(baseConnection, false, true);
        this.conn = baseConnection;
        this.conn.setAutoCommit(false);
        this.state = 0;
        this.logger = baseConnection.getLogger();
    }

    public Connection getConnection() throws SQLException {
        return super.getConnection();
    }

    public XAResource getXAResource() {
        return this;
    }

    public void start(Xid xid, int n) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("starting transaction xid = " + xid);
        }
        if (n != 0 && n != 0x8000000 && n != 0x200000) {
            throw new PGXAException(GT.tr("Invalid flags"), -5);
        }
        if (xid == null) {
            throw new PGXAException(GT.tr("xid must not be null"), -5);
        }
        if (this.state == 1) {
            throw new PGXAException(GT.tr("Connection is busy with another transaction"), -6);
        }
        if (n != 0) {
            throw new PGXAException(GT.tr("suspend/resume and join not implemented"), -3);
        }
        if (this.state == 2) {
            throw new PGXAException(GT.tr("Transaction interleaving not implemented"), -3);
        }
        this.state = 1;
        this.currentXid = xid;
    }

    public void end(Xid xid, int n) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("ending transaction xid = " + xid);
        }
        if (n != 0x2000000 && n != 0x20000000 && n != 0x4000000) {
            throw new PGXAException(GT.tr("Invalid flags"), -5);
        }
        if (xid == null) {
            throw new PGXAException(GT.tr("xid must not be null"), -5);
        }
        if (this.state != 1 || !this.currentXid.equals(xid)) {
            throw new PGXAException(GT.tr("tried to call end without corresponding start call"), -6);
        }
        if (n == 0x2000000) {
            throw new PGXAException(GT.tr("suspend/resume not implemented"), -3);
        }
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("preparing transaction xid = " + xid);
        }
        if (!this.currentXid.equals(xid)) {
            throw new PGXAException(GT.tr("Not implemented: Prepare must be issued using the same connection that started the transaction"), -3);
        }
        if (this.state != 2) {
            throw new PGXAException(GT.tr("Prepare called before end"), -5);
        }
        this.state = 0;
        this.currentXid = null;
        if (!this.conn.haveMinimumServerVersion("8.1")) {
            throw new PGXAException(GT.tr("Server versions prior to 8.1 do not support two-phase commit."), -3);
        }
        try {
            String string = RecoveredXid.xidToString(xid);
            Statement statement = this.conn.createStatement();
            try {
                statement.executeUpdate("PREPARE TRANSACTION '" + string + "'");
            }
            finally {
                statement.close();
            }
            return 0;
        }
        catch (SQLException sQLException) {
            throw new PGXAException(GT.tr("Error preparing transaction"), sQLException, -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        if (n != 0x1000000 && n != 0x800000 && n != 0 && n != 0x1800000) {
            throw new PGXAException(GT.tr("Invalid flag"), -5);
        }
        if ((n & 0x1000000) == 0) {
            return new Xid[0];
        }
        Statement statement = this.conn.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT gid FROM pg_prepared_xacts");
            LinkedList<Xid[]> linkedList = new LinkedList<Xid[]>();
            while (resultSet.next()) {
                xidArray = RecoveredXid.stringToXid(resultSet.getString(1));
                if (xidArray == null) continue;
                linkedList.add(xidArray);
            }
            resultSet.close();
            xidArray = linkedList.toArray(new Xid[linkedList.size()]);
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw new PGXAException(GT.tr("Error during recover"), sQLException, -3);
            }
        }
        statement.close();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        block10: {
            if (this.logger.logDebug()) {
                this.debug("rolling back xid = " + xid);
            }
            try {
                if (this.currentXid != null && xid.equals(this.currentXid)) {
                    this.state = 0;
                    this.currentXid = null;
                    this.conn.rollback();
                    break block10;
                }
                String string = RecoveredXid.xidToString(xid);
                this.conn.setAutoCommit(true);
                try {
                    Statement statement = this.conn.createStatement();
                    try {
                        statement.executeUpdate("ROLLBACK PREPARED '" + string + "'");
                    }
                    finally {
                        statement.close();
                    }
                }
                finally {
                    this.conn.setAutoCommit(false);
                }
            }
            catch (SQLException sQLException) {
                throw new PGXAException(GT.tr("Error rolling back prepared transaction"), sQLException, -3);
            }
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("committing xid = " + xid + (bl ? " (one phase) " : " (two phase)"));
        }
        if (xid == null) {
            throw new PGXAException(GT.tr("xid must not be null"), -5);
        }
        if (bl) {
            this.commitOnePhase(xid);
        } else {
            this.commitPrepared(xid);
        }
    }

    private void commitOnePhase(Xid xid) throws XAException {
        try {
            if (this.currentXid == null || !this.currentXid.equals(xid)) {
                throw new PGXAException(GT.tr("Not implemented: one-phase commit must be issued using the same connection that was used to start it"), -3);
            }
            if (this.state != 2) {
                throw new PGXAException(GT.tr("commit called before end"), -6);
            }
            this.state = 0;
            this.currentXid = null;
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new PGXAException(GT.tr("Error during one-phase commit"), sQLException, -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPrepared(Xid xid) throws XAException {
        try {
            if (this.state != 0) {
                throw new PGXAException(GT.tr("Not implemented: 2nd phase commit must be issued using an idle connection"), -3);
            }
            String string = RecoveredXid.xidToString(xid);
            this.conn.setAutoCommit(true);
            try {
                Statement statement = this.conn.createStatement();
                try {
                    statement.executeUpdate("COMMIT PREPARED '" + string + "'");
                }
                finally {
                    statement.close();
                }
            }
            finally {
                this.conn.setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return xAResource == this;
    }

    public void forget(Xid xid) throws XAException {
        throw new PGXAException(GT.tr("Heuristic commit/rollback not supported"), -4);
    }

    public int getTransactionTimeout() {
        return 0;
    }

    public boolean setTransactionTimeout(int n) {
        return false;
    }
}

