/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.xa;

import com.vertica.util.Base64;
import java.util.Arrays;
import javax.transaction.xa.Xid;

class RecoveredXid
implements Xid {
    int formatId;
    byte[] globalTransactionId;
    byte[] branchQualifier;

    RecoveredXid() {
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        Xid xid = (Xid)object;
        if (xid.getFormatId() != this.formatId) {
            return false;
        }
        if (!Arrays.equals(this.globalTransactionId, xid.getGlobalTransactionId())) {
            return false;
        }
        return Arrays.equals(this.branchQualifier, xid.getBranchQualifier());
    }

    public String toString() {
        return RecoveredXid.xidToString(this);
    }

    static String xidToString(Xid xid) {
        return xid.getFormatId() + "_" + Base64.encodeBytes(xid.getGlobalTransactionId(), 8) + "_" + Base64.encodeBytes(xid.getBranchQualifier(), 8);
    }

    static Xid stringToXid(String string) {
        int n;
        RecoveredXid recoveredXid = new RecoveredXid();
        int n2 = string.indexOf("_");
        if (n2 == (n = string.lastIndexOf("_"))) {
            return null;
        }
        try {
            recoveredXid.formatId = Integer.parseInt(string.substring(0, n2));
            recoveredXid.globalTransactionId = Base64.decode(string.substring(n2 + 1, n));
            recoveredXid.branchQualifier = Base64.decode(string.substring(n + 1));
            if (recoveredXid.globalTransactionId == null || recoveredXid.branchQualifier == null) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return recoveredXid;
    }
}

