/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

public class HostAddress {
    public String host;
    public int port;

    public static HostAddress[] parse(String spec) {
        String[] tokens = spec.split(",");
        HostAddress[] arr = new HostAddress[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            arr[i] = HostAddress.parseSingleHostAddress(tokens[i]);
            ++i;
        }
        int defaultPort = arr[arr.length - 1].port;
        if (defaultPort == 0) {
            defaultPort = 3306;
        }
        int i2 = 0;
        while (i2 < arr.length) {
            if (arr[i2].port == 0) {
                arr[i2].port = defaultPort;
            }
            ++i2;
        }
        return arr;
    }

    static HostAddress parseSingleHostAddress(String s) {
        HostAddress result = new HostAddress();
        if (s.startsWith("[")) {
            int ind = s.indexOf(93);
            result.host = s.substring(1, ind);
            if (ind != s.length() - 1 && s.charAt(ind + 1) == ':') {
                result.port = Integer.parseInt(s.substring(ind + 2));
            }
        } else if (s.contains(":")) {
            String[] hostPort = s.split(":");
            result.host = hostPort[0];
            result.port = Integer.parseInt(hostPort[1]);
        } else {
            result.host = s;
        }
        return result;
    }

    public static String toString(HostAddress[] addrs) {
        String s = "";
        int i = 0;
        while (i < addrs.length) {
            boolean isIPv6 = addrs[i].host != null && addrs[i].host.contains(":");
            String host = isIPv6 ? "[" + addrs[i].host + "]" : addrs[i].host;
            s = String.valueOf(s) + host + ":" + addrs[i].port;
            if (i < addrs.length - 1) {
                s = String.valueOf(s) + ",";
            }
            ++i;
        }
        return s;
    }
}

