/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import org.mariadb.jdbc.HostAddress;

public class JDBCUrl {
    private String username;
    private String password;
    private String database;
    private HostAddress[] addresses;

    private JDBCUrl(String username, String password, String database, HostAddress[] addresses) {
        this.username = username;
        this.password = password;
        this.database = database;
        this.addresses = addresses;
    }

    private static JDBCUrl parseConnectorJUrl(String url) {
        if (!url.startsWith("jdbc:mysql://")) {
            return null;
        }
        url = url.substring(13);
        String[] tokens = url.split("/");
        String hostname = tokens[0];
        String database = tokens.length > 1 ? tokens[1] : null;
        return new JDBCUrl("", "", database, HostAddress.parse(hostname));
    }

    static boolean acceptsURL(String url) {
        return url != null && (url.startsWith("jdbc:mariadb://") || url.startsWith("jdbc:mysql://")) && !url.startsWith("jdbc:mysql://address=");
    }

    public static JDBCUrl parse(String url) {
        String[] arr;
        if (url.startsWith("jdbc:mysql://")) {
            return JDBCUrl.parseConnectorJUrl(url);
        }
        String[] stringArray = arr = new String[]{"jdbc:mysql:thin://", "jdbc:mariadb://"};
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (url.startsWith(prefix)) {
                return JDBCUrl.parseConnectorJUrl("jdbc:mysql://" + url.substring(prefix.length()));
            }
            ++n2;
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.addresses[0].host;
    }

    public int getPort() {
        return this.addresses[0].port;
    }

    public String getDatabase() {
        return this.database;
    }

    public HostAddress[] getHostAddresses() {
        return this.addresses;
    }

    public String toString() {
        String s = "jdbc:mysql://";
        if (this.addresses != null) {
            s = String.valueOf(s) + HostAddress.toString(this.addresses);
        }
        if (this.database != null) {
            s = String.valueOf(s) + "/" + this.database;
        }
        return s;
    }
}

