/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mariadb.jdbc.MySQLBlob;
import org.mariadb.jdbc.MySQLClob;
import org.mariadb.jdbc.internal.common.DataType;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public abstract class AbstractValueObject
implements ValueObject {
    private final byte[] rawBytes;
    protected final DataType dataType;

    protected AbstractValueObject(byte[] rawBytes, DataType dataType) {
        this.dataType = dataType;
        this.rawBytes = rawBytes;
    }

    @Override
    public String getString() {
        if (this.rawBytes == null) {
            return null;
        }
        try {
            return new String(this.rawBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public long getLong() {
        if (this.rawBytes == null) {
            return 0L;
        }
        try {
            return Long.valueOf(this.getString());
        }
        catch (NumberFormatException nfe) {
            BigDecimal d = new BigDecimal(this.getString());
            if (d.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
                return Long.MIN_VALUE;
            }
            if (d.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
                return Long.MAX_VALUE;
            }
            return d.longValue();
        }
    }

    @Override
    public int getInt() {
        if (this.rawBytes == null) {
            return 0;
        }
        try {
            return Integer.valueOf(this.getString());
        }
        catch (NumberFormatException nfe) {
            BigDecimal d = new BigDecimal(this.getString());
            if (d.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) < 0) {
                return Integer.MIN_VALUE;
            }
            if (d.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                return Integer.MAX_VALUE;
            }
            return d.intValue();
        }
    }

    @Override
    public short getShort() {
        if (this.rawBytes == null) {
            return 0;
        }
        try {
            return Short.valueOf(this.getString());
        }
        catch (NumberFormatException nfe) {
            BigDecimal d = new BigDecimal(this.getString());
            if (d.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
                return Short.MIN_VALUE;
            }
            if (d.compareTo(BigDecimal.valueOf(32767L)) > 0) {
                return Short.MAX_VALUE;
            }
            return d.shortValue();
        }
    }

    @Override
    public byte getByte() {
        if (this.rawBytes == null) {
            return 0;
        }
        if (this.dataType.getType() == MySQLType.Type.BIT) {
            return this.rawBytes[0];
        }
        return Byte.valueOf(this.getString());
    }

    @Override
    public byte[] getBytes() {
        return this.rawBytes;
    }

    @Override
    public float getFloat() {
        if (this.rawBytes == null) {
            return 0.0f;
        }
        return Float.valueOf(this.getString()).floatValue();
    }

    @Override
    public double getDouble() {
        if (this.rawBytes == null) {
            return 0.0;
        }
        return Double.valueOf(this.getString());
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.rawBytes == null) {
            return null;
        }
        return new BigDecimal(this.getString());
    }

    @Override
    public BigInteger getBigInteger() {
        if (this.rawBytes == null) {
            return null;
        }
        return new BigInteger(this.getString());
    }

    @Override
    public Date getDate() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = this.dataType.getType() == MySQLType.Type.YEAR ? (this.rawBytes.length == 2 ? new SimpleDateFormat("yy") : new SimpleDateFormat("yyyy")) : new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date utilDate = sdf.parse(rawValue);
        return new Date(utilDate.getTime());
    }

    @Override
    public Time getTime() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        java.util.Date utilTime = sdf.parse(rawValue);
        long t0 = utilTime.getTime();
        int nanos = this.extractNanos(rawValue);
        int milliseconds = nanos / 1000000;
        return new Time(t0 + (long)milliseconds);
    }

    private int extractNanos(String timestring) throws ParseException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        int i = index + 1;
        while (i < index + 10) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char c = timestring.charAt(i);
                if (c < '0' || c > '9') {
                    throw new ParseException("cannot parse subsecond part in timestamp string '" + timestring + "'", i);
                }
                digit = c - 48;
            }
            nanos = nanos * 10 + digit;
            ++i;
        }
        return nanos;
    }

    @Override
    public Timestamp getTimestamp() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = rawValue.length() > 11 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        java.util.Date utilTime = sdf.parse(rawValue);
        Timestamp ts = new Timestamp(utilTime.getTime());
        if (rawValue.indexOf(46) != -1) {
            ts.setNanos(this.extractNanos(rawValue));
        }
        return ts;
    }

    @Override
    public InputStream getInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getString().getBytes());
    }

    @Override
    public InputStream getBinaryInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rawBytes);
    }

    @Override
    public abstract Object getObject(int var1) throws ParseException;

    @Override
    public Date getDate(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setCalendar(cal);
        java.util.Date utilDate = sdf.parse(rawValue);
        return new Date(utilDate.getTime());
    }

    @Override
    public Time getTime(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setCalendar(cal);
        return new Time(sdf.parse(rawValue).getTime());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setCalendar(cal);
        java.util.Date utilTime = sdf.parse(rawValue);
        return new Timestamp(utilTime.getTime());
    }

    @Override
    public boolean getBoolean() {
        if (this.rawBytes == null) {
            return false;
        }
        String rawVal = this.getString();
        return rawVal.equalsIgnoreCase("true") || rawVal.equalsIgnoreCase("1") || (this.rawBytes[0] & 1) == 1;
    }

    @Override
    public boolean isNull() {
        return this.rawBytes == null;
    }

    @Override
    public int getDisplayLength() {
        if (this.rawBytes != null) {
            return this.rawBytes.length;
        }
        return 4;
    }

    @Override
    public Blob getBlob() {
        if (this.rawBytes == null) {
            return null;
        }
        return new MySQLBlob(this.rawBytes);
    }

    @Override
    public Clob getClob() {
        if (this.rawBytes == null) {
            return null;
        }
        return new MySQLClob(this.rawBytes);
    }
}

