/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;

public class EOFPacket
extends ResultPacket {
    private final byte packetSeq;
    private final short warningCount;
    private final Set<ServerStatus> statusFlags;

    public EOFPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        this.packetSeq = 0;
        reader.readByte();
        this.warningCount = reader.readShort();
        this.statusFlags = ServerStatus.getServerCapabilitiesSet(reader.readShort());
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.EOF;
    }

    @Override
    public byte getPacketSeq() {
        return this.packetSeq;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    public Set<ServerStatus> getStatusFlags() {
        return this.statusFlags;
    }

    public String toString() {
        return "EOFPacket{packetSeq=" + this.packetSeq + ", warningCount=" + this.warningCount + ", statusFlags=" + this.statusFlags + '}';
    }

    public static enum ServerStatus {
        SERVER_STATUS_IN_TRANS(1),
        SERVER_STATUS_AUTOCOMMIT(2),
        SERVER_MORE_RESULTS_EXISTS(8),
        SERVER_QUERY_NO_GOOD_INDEX_USED(16),
        SERVER_QUERY_NO_INDEX_USED(32),
        SERVER_STATUS_DB_DROPPED(256);

        private final int bitmapFlag;

        private ServerStatus(int bitmapFlag) {
            this.bitmapFlag = bitmapFlag;
        }

        public static Set<ServerStatus> getServerCapabilitiesSet(short i) {
            EnumSet<ServerStatus> statusSet = EnumSet.noneOf(ServerStatus.class);
            ServerStatus[] serverStatusArray = ServerStatus.values();
            int n = serverStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServerStatus value = serverStatusArray[n2];
                if ((i & value.getBitmapFlag()) == value.getBitmapFlag()) {
                    statusSet.add(value);
                }
                ++n2;
            }
            return statusSet;
        }

        public int getBitmapFlag() {
            return this.bitmapFlag;
        }
    }
}

