/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ParameterWriter {
    static final byte[] BINARY_INTRODUCER = new byte[]{95, 98, 105, 110, 97, 114, 121, 32, 39};
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final int QUOTE = 39;

    private static void writeBytesEscaped(OutputStream out, byte[] bytes, int count, boolean noBackslashEscapes) throws IOException {
        if (noBackslashEscapes) {
            int i = 0;
            while (i < count) {
                byte b = bytes[i];
                switch (b) {
                    case 39: {
                        out.write(39);
                        out.write(b);
                        break;
                    }
                    default: {
                        out.write(b);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < count) {
                byte b = bytes[i];
                switch (b) {
                    case 0: 
                    case 34: 
                    case 39: 
                    case 92: {
                        out.write(92);
                        out.write(b);
                        break;
                    }
                    default: {
                        out.write(b);
                    }
                }
                ++i;
            }
        }
    }

    private static void writeBytesEscaped(OutputStream out, byte[] bytes, boolean noBackslashEscapes) throws IOException {
        ParameterWriter.writeBytesEscaped(out, bytes, bytes.length, noBackslashEscapes);
    }

    public static void write(OutputStream out, byte[] bytes, boolean noBackslashEscapes) throws IOException {
        out.write(BINARY_INTRODUCER);
        ParameterWriter.writeBytesEscaped(out, bytes, noBackslashEscapes);
        out.write(39);
    }

    public static void write(OutputStream out, String s, boolean noBackslashEscapes) throws IOException {
        byte[] bytes = s.getBytes(UTF8);
        out.write(39);
        ParameterWriter.writeBytesEscaped(out, bytes, noBackslashEscapes);
        out.write(39);
    }

    public static void write(OutputStream out, InputStream is, boolean noBackslashEscapes) throws IOException {
        int len;
        out.write(BINARY_INTRODUCER);
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            ParameterWriter.writeBytesEscaped(out, buffer, len, noBackslashEscapes);
        }
        out.write(39);
    }

    public static void write(OutputStream out, InputStream is, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int bytesToRead;
        out.write(BINARY_INTRODUCER);
        byte[] buffer = new byte[1024];
        long bytesLeft = length;
        while ((bytesToRead = (int)Math.min(bytesLeft, (long)buffer.length)) != 0 && (len = is.read(buffer, 0, bytesToRead)) > 0) {
            ParameterWriter.writeBytesEscaped(out, buffer, len, noBackslashEscapes);
            bytesLeft -= (long)len;
        }
        out.write(39);
    }

    public static void write(OutputStream out, Reader reader, boolean noBackslashEscapes) throws IOException {
        int len;
        out.write(39);
        char[] buffer = new char[1024];
        while ((len = reader.read(buffer)) >= 0) {
            ParameterWriter.writeBytesEscaped(out, new String(buffer, 0, len).getBytes(UTF8), noBackslashEscapes);
        }
        out.write(39);
    }

    public static void write(OutputStream out, Reader reader, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int charsToRead;
        out.write(39);
        char[] buffer = new char[1024];
        long charsLeft = length;
        while ((charsToRead = (int)Math.min(charsLeft, (long)buffer.length)) != 0 && (len = reader.read(buffer, 0, charsToRead)) > 0) {
            ParameterWriter.writeBytesEscaped(out, new String(buffer).getBytes(UTF8), len, noBackslashEscapes);
            charsLeft -= (long)len;
        }
        out.write(39);
    }

    public static void write(OutputStream out, int i) throws IOException {
        out.write(String.valueOf(i).getBytes());
    }

    public static void write(OutputStream out, long l) throws IOException {
        out.write(String.valueOf(l).getBytes());
    }

    public static void write(OutputStream out, double d) throws IOException {
        out.write(String.valueOf(d).getBytes());
    }

    public static void write(OutputStream out, BigDecimal bd) throws IOException {
        out.write(bd.toPlainString().getBytes());
    }

    public static void writeDate(OutputStream out, Date date, Calendar calendar) throws IOException {
        String dateString;
        out.write(39);
        if (calendar != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setCalendar(calendar);
            dateString = sdf.format(date);
        } else {
            dateString = date.toString();
        }
        out.write(dateString.getBytes());
        out.write(39);
    }

    static void formatMicroseconds(OutputStream out, int microseconds, boolean writeFractionalSeconds) throws IOException {
        if (microseconds == 0 || !writeFractionalSeconds) {
            return;
        }
        out.write(46);
        int factor = 100000;
        while (microseconds > 0) {
            int dig = microseconds / factor;
            out.write(48 + dig);
            microseconds -= dig * factor;
            factor /= 10;
        }
    }

    public static void writeTimestamp(OutputStream out, Timestamp ts, Calendar calendar, boolean writeFractionalSeconds) throws IOException {
        out.write(39);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (calendar != null) {
            sdf.setCalendar(calendar);
        }
        String dateString = sdf.format(ts);
        out.write(dateString.getBytes());
        ParameterWriter.formatMicroseconds(out, ts.getNanos() / 1000, writeFractionalSeconds);
        out.write(39);
    }

    public static void writeTime(OutputStream out, Time time, Calendar calendar, boolean writeFractionalSeconds) throws IOException {
        out.write(39);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        if (calendar != null) {
            sdf.setCalendar(calendar);
        }
        String dateString = sdf.format(time);
        out.write(dateString.getBytes());
        int microseconds = (int)(time.getTime() % 1000L) * 1000;
        ParameterWriter.formatMicroseconds(out, microseconds, writeFractionalSeconds);
        out.write(39);
    }

    public static void writeObject(OutputStream out, Object o, boolean noBackslashEscapes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        ParameterWriter.write(out, baos.toByteArray(), noBackslashEscapes);
    }
}

