/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.queryresults;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.ColumnInformation;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.common.packet.EOFPacket;
import org.mariadb.jdbc.internal.common.packet.ErrorPacket;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacketFactory;
import org.mariadb.jdbc.internal.common.packet.ResultSetPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.ReadUtil;
import org.mariadb.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.packet.MySQLRowPacket;

public class StreamingSelectResult
extends SelectQueryResult {
    PacketFetcher packetFetcher;
    public ValueObject[] values;
    MySQLProtocol protocol;
    boolean isEOF;
    boolean beforeFirst;

    private StreamingSelectResult(ColumnInformation[] info, MySQLProtocol protocol, PacketFetcher fetcher) throws QueryException {
        this.columnInformation = info;
        this.protocol = protocol;
        this.packetFetcher = fetcher;
        this.beforeFirst = true;
        this.isEOF = false;
        protocol.activeResult = this;
    }

    public static StreamingSelectResult createStreamingSelectResult(ResultSetPacket packet, PacketFetcher packetFetcher, MySQLProtocol protocol) throws IOException, QueryException {
        if (protocol.activeResult != null) {
            throw new QueryException("There is an active result set on the current connection, which must be closed prior to opening a new one");
        }
        long fieldCount = packet.getFieldCount();
        ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
        int i = 0;
        while ((long)i < fieldCount) {
            RawPacket rawPacket = packetFetcher.getRawPacket();
            if (ReadUtil.isErrorPacket(rawPacket)) {
                ErrorPacket errorPacket = new ErrorPacket(rawPacket);
                throw new QueryException("error when reading field packet " + errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
            }
            byte b = rawPacket.getByteBuffer().get(0);
            if (b == 0 || b == -2) {
                throw new QueryException("Packets out of order when trying to read field packet - got packet starting with byte " + b + "packet content (hex) = " + MySQLProtocol.hexdump(rawPacket.getByteBuffer(), 0));
            }
            try {
                ci[i] = new MySQLColumnInformation(rawPacket);
            }
            catch (Exception e) {
                throw new QueryException("Error when trying to parse field packet : " + e + ",packet content (hex) = " + MySQLProtocol.hexdump(rawPacket.getByteBuffer(), 0), 0, "HY000", e);
            }
            ++i;
        }
        RawPacket fieldEOF = packetFetcher.getRawPacket();
        if (!ReadUtil.eofIsNext(fieldEOF)) {
            throw new QueryException("Packets out of order when reading field packets, expected was EOF packet. Packet contents (hex) = " + MySQLProtocol.hexdump(fieldEOF.getByteBuffer(), 0));
        }
        return new StreamingSelectResult(ci, protocol, packetFetcher);
    }

    @Override
    public boolean next() throws IOException, QueryException {
        if (this.isEOF) {
            return false;
        }
        RawPacket rawPacket = this.packetFetcher.getRawPacket();
        if (ReadUtil.isErrorPacket(rawPacket)) {
            this.protocol.activeResult = null;
            this.protocol.moreResults = false;
            ErrorPacket errorPacket = (ErrorPacket)ResultPacketFactory.createResultPacket(rawPacket);
            throw new QueryException(errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
        }
        if (ReadUtil.eofIsNext(rawPacket)) {
            EOFPacket eofPacket = (EOFPacket)ResultPacketFactory.createResultPacket(rawPacket);
            this.protocol.activeResult = null;
            this.protocol.moreResults = eofPacket.getStatusFlags().contains((Object)EOFPacket.ServerStatus.SERVER_MORE_RESULTS_EXISTS);
            this.warningCount = eofPacket.getWarningCount();
            this.protocol.hasWarnings = this.warningCount > 0;
            this.isEOF = true;
            this.values = null;
            return false;
        }
        MySQLRowPacket rowPacket = new MySQLRowPacket(rawPacket, this.columnInformation);
        this.values = rowPacket.getRow(this.packetFetcher);
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ValueObject getValueObject(int i) throws NoSuchColumnException {
        return this.values[i];
    }

    @Override
    public int getRows() {
        return -1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.beforeFirst;
    }

    @Override
    public boolean isAfterLast() {
        return this.isEOF;
    }
}

