/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.packet.CommandPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.packet.buffer.WriteBuffer;

public class MySQLClientOldPasswordAuthPacket
implements CommandPacket {
    private final WriteBuffer writeBuffer = new WriteBuffer();
    private int packSeq = 0;

    public MySQLClientOldPasswordAuthPacket(String password, byte[] seed, int packSeq) {
        this.packSeq = packSeq;
        byte[] oldPassword = this.cryptOldFormatPassword(password, new String(seed));
        this.writeBuffer.writeByteArray(oldPassword).writeByte((byte)0);
    }

    @Override
    public int send(OutputStream os) throws IOException, QueryException {
        PacketOutputStream pos = (PacketOutputStream)os;
        pos.startPacket(this.packSeq);
        pos.write(this.writeBuffer.getBuffer(), 0, this.writeBuffer.getLength());
        pos.finishPacket();
        return this.packSeq;
    }

    private byte[] cryptOldFormatPassword(String password, String seed) {
        byte[] result = new byte[seed.length()];
        if (password == null || password.length() == 0) {
            return new byte[0];
        }
        long[] seedHash = this.hashPassword(seed);
        long[] passHash = this.hashPassword(password);
        randStruct randSeed = new randStruct(seedHash[0] ^ passHash[0], seedHash[1] ^ passHash[1]);
        int i = 0;
        while (i < seed.length()) {
            result[i] = (byte)Math.floor(this.random(randSeed) * 31.0 + 64.0);
            ++i;
        }
        byte extra = (byte)Math.floor(this.random(randSeed) * 31.0);
        int i2 = 0;
        while (i2 < seed.length()) {
            int n = i2++;
            result[n] = (byte)(result[n] ^ extra);
        }
        return result;
    }

    private double random(randStruct rand) {
        rand.seed1 = (rand.seed1 * 3L + rand.seed2) % rand.maxValue;
        rand.seed2 = (rand.seed1 + rand.seed2 + 33L) % rand.maxValue;
        double d = rand.seed1;
        rand.getClass();
        return d / 1.073741823E9;
    }

    private long[] hashPassword(String password) {
        long nr = 1345345333L;
        long nr2 = 305419889L;
        long add = 7L;
        int i = 0;
        while (i < password.length()) {
            char currChar = password.charAt(i);
            if (currChar != ' ' && currChar != '\t') {
                long tmp = currChar;
                nr ^= ((nr & 0x3FL) + add) * tmp + (nr << 8);
                nr2 += nr2 << 8 ^ nr;
                add += tmp;
            }
            ++i;
        }
        return new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
    }

    private class randStruct {
        long seed1;
        long seed2;
        final long maxValue = 0x3FFFFFFFL;

        public randStruct(long seed1, long seed2) {
            this.seed1 = seed1 % 0x3FFFFFFFL;
            this.seed2 = seed2 % 0x3FFFFFFFL;
        }
    }
}

