/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.ErrorMessage;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResult;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.Invocation;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.Result;
import org.easymock.internal.UnorderedBehavior;

public class MocksBehavior
implements IMocksBehavior,
Serializable {
    private static final long serialVersionUID = 3265727009370529027L;
    private final List<UnorderedBehavior> behaviorLists = new ArrayList<UnorderedBehavior>();
    private final List<ExpectedInvocationAndResult> stubResults = new ArrayList<ExpectedInvocationAndResult>();
    private final boolean nice;
    private boolean checkOrder;
    private boolean isThreadSafe;
    private boolean shouldBeUsedInOneThread;
    private int position = 0;
    private volatile transient Thread lastThread;

    public MocksBehavior(boolean nice) {
        this.nice = nice;
        this.isThreadSafe = Boolean.valueOf(EasyMockProperties.getInstance().getProperty("easymock.notThreadSafeByDefault")) == false;
        this.shouldBeUsedInOneThread = Boolean.valueOf(EasyMockProperties.getInstance().getProperty("easymock.enableThreadSafetyCheckByDefault"));
    }

    public final void addStub(ExpectedInvocation expected, Result result) {
        this.stubResults.add(new ExpectedInvocationAndResult(expected, result));
    }

    public void addExpected(ExpectedInvocation expected, Result result, Range count) {
        this.addBehaviorListIfNecessary(expected);
        this.lastBehaviorList().addExpected(expected, result, count);
    }

    private Result getStubResult(Invocation actual) {
        for (ExpectedInvocationAndResult each : this.stubResults) {
            if (!each.getExpectedInvocation().matches(actual)) continue;
            return each.getResult();
        }
        return null;
    }

    private void addBehaviorListIfNecessary(ExpectedInvocation expected) {
        if (this.behaviorLists.isEmpty() || !this.lastBehaviorList().allowsExpectedInvocation(expected, this.checkOrder)) {
            this.behaviorLists.add(new UnorderedBehavior(this.checkOrder));
        }
    }

    private UnorderedBehavior lastBehaviorList() {
        return this.behaviorLists.get(this.behaviorLists.size() - 1);
    }

    public final Result addActual(Invocation actual) {
        Result stubOrNice;
        int initialPosition = this.position;
        while (this.position < this.behaviorLists.size()) {
            Result result = this.behaviorLists.get(this.position).addActual(actual);
            if (result != null) {
                return result;
            }
            if (!this.behaviorLists.get(this.position).verify()) break;
            ++this.position;
        }
        if ((stubOrNice = this.getStubResult(actual)) == null && this.nice) {
            stubOrNice = Result.createReturnResult(RecordState.emptyReturnValueFor(actual.getMethod().getReturnType()));
        }
        int endPosition = this.position;
        this.position = initialPosition;
        if (stubOrNice != null) {
            actual.validateCaptures();
            actual.clearCaptures();
            return stubOrNice;
        }
        if (endPosition == this.behaviorLists.size()) {
            --endPosition;
        }
        StringBuilder errorMessage = new StringBuilder(70 * (endPosition - initialPosition + 1));
        errorMessage.append("\n  Unexpected method call ").append(actual.toString());
        ArrayList<ErrorMessage> messages = new ArrayList<ErrorMessage>();
        int matches = 0;
        for (int i = initialPosition; i <= endPosition; ++i) {
            List<ErrorMessage> thisListMessages = this.behaviorLists.get(i).getMessages(actual);
            messages.addAll(thisListMessages);
            for (ErrorMessage m : thisListMessages) {
                if (!m.isMatching()) continue;
                ++matches;
            }
        }
        if (matches > 1) {
            errorMessage.append(". Possible matches are marked with (+1):");
        } else {
            errorMessage.append(":");
        }
        for (ErrorMessage m : messages) {
            m.appendTo(errorMessage, matches);
        }
        throw new AssertionErrorWrapper(new AssertionError(errorMessage));
    }

    public void verify() {
        boolean verified = true;
        for (UnorderedBehavior behaviorList : this.behaviorLists.subList(this.position, this.behaviorLists.size())) {
            if (behaviorList.verify()) continue;
            verified = false;
        }
        if (verified) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder(70 * (this.behaviorLists.size() - this.position + 1));
        errorMessage.append("\n  Expectation failure on verify:");
        for (UnorderedBehavior behaviorList : this.behaviorLists.subList(this.position, this.behaviorLists.size())) {
            for (ErrorMessage m : behaviorList.getMessages(null)) {
                m.appendTo(errorMessage, 0);
            }
        }
        throw new AssertionErrorWrapper(new AssertionError((Object)errorMessage.toString()));
    }

    public void checkOrder(boolean value) {
        this.checkOrder = value;
    }

    public void makeThreadSafe(boolean isThreadSafe) {
        this.isThreadSafe = isThreadSafe;
    }

    public void shouldBeUsedInOneThread(boolean shouldBeUsedInOneThread) {
        this.shouldBeUsedInOneThread = shouldBeUsedInOneThread;
    }

    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public void checkThreadSafety() {
        if (!this.shouldBeUsedInOneThread) {
            return;
        }
        if (this.lastThread == null) {
            this.lastThread = Thread.currentThread();
        } else if (this.lastThread != Thread.currentThread()) {
            throw new AssertionErrorWrapper(new AssertionError((Object)("\n Mock isn't supposed to be called from multiple threads. Last: " + this.lastThread + " Current: " + Thread.currentThread())));
        }
    }
}

