/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.Base64;
import org.jboss.dmr.JSONParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.yuanheng.cookcc.CookCCOption;
import org.yuanheng.cookcc.CookCCToken;
import org.yuanheng.cookcc.Lex;
import org.yuanheng.cookcc.Lexs;
import org.yuanheng.cookcc.Rule;
import org.yuanheng.cookcc.Rules;

@CookCCOption
public class JSONParserImpl
extends JSONParser {
    private ModelNode result;

    @Lexs(patterns={@Lex(pattern="\\{", token="OPEN_BRACE"), @Lex(pattern="\\}", token="CLOSE_BRACE"), @Lex(pattern="\\[", token="OPEN_BRACKET"), @Lex(pattern="\\]", token="CLOSE_BRACKET"), @Lex(pattern=",", token="COMMA"), @Lex(pattern=":", token="COLON"), @Lex(pattern="true", token="TRUE"), @Lex(pattern="false", token="FALSE"), @Lex(pattern="big", token="BIG"), @Lex(pattern="decimal", token="DECIMAL"), @Lex(pattern="integer", token="INTEGER"), @Lex(pattern="null", token="UNDEFINED")})
    protected Void parseToken() {
        return null;
    }

    @Lexs(patterns={@Lex(pattern="[+-]?[0-9]+L", token="LONG_VAL"), @Lex(pattern="[+-]?0x[0-9a-fA-F]+L", token="LONG_HEX_VAL"), @Lex(pattern="[+-]?[0-9]+", token="INT_VAL"), @Lex(pattern="[+-]?0x[0-9a-fA-F]+", token="INT_HEX_VAL"), @Lex(pattern="[+-]?(NaN|Infinity)", token="DOUBLE_SPECIAL_VAL"), @Lex(pattern="[+-]?([0-9]+\\.[0-9]+([eE][+-]?[0-9]+)?)", token="DEC_VAL")})
    protected String parsePlainValue() {
        return this.yyText();
    }

    @Lex(pattern="\\\"([^\"\\\\]+|\\\\.)*\\\"", token="STR_VAL")
    protected String parseStringValue() {
        String yyText = this.yyText();
        int length = yyText.length();
        StringBuilder b = new StringBuilder(length);
        int i = 1;
        while (i < length - 1) {
            int ch = yyText.codePointAt(i);
            block0 : switch (ch) {
                case 92: {
                    i = yyText.offsetByCodePoints(i, 1);
                    ch = yyText.codePointAt(i);
                    switch (ch) {
                        case 110: {
                            b.append('\n');
                            break block0;
                        }
                        case 114: {
                            b.append('\r');
                            break block0;
                        }
                        case 98: {
                            b.append('\b');
                            break block0;
                        }
                        case 102: {
                            b.append('\f');
                            break block0;
                        }
                        case 117: {
                            b.append((char)Integer.parseInt(yyText.substring(i + 1, i + 5)));
                            i += 4;
                            break block0;
                        }
                    }
                    b.appendCodePoint(ch);
                    break;
                }
                default: {
                    b.appendCodePoint(ch);
                }
            }
            i = yyText.offsetByCodePoints(i, 1);
        }
        return b.toString();
    }

    @Lex(pattern="[ \\t\\r\\n]+")
    protected void ignored() {
    }

    @Lex(pattern=".")
    protected void invalid() throws IOException {
        throw new IOException("Invalid character: " + this.yyText());
    }

    @Lex(pattern="<<EOF>>", token="$")
    protected void parseEOF() {
    }

    @Rule(lhs="complete", rhs="node", args="1")
    protected int parse(ModelNode node) {
        this.result = node;
        return 0;
    }

    @Rules(rules={@Rule(lhs="node", rhs="DEC_VAL", args="1")})
    protected ModelNode parseBigDecimal(String arg) {
        return new ModelNode().set(new BigDecimal(arg));
    }

    @Rules(rules={@Rule(lhs="node", rhs="INT_VAL", args="1")})
    protected ModelNode parseBigInteger(String arg) {
        return new ModelNode().set(new BigInteger(arg));
    }

    @Rule(lhs="node", rhs="TRUE")
    protected ModelNode parseTrue() {
        return new ModelNode().set(Boolean.TRUE);
    }

    @Rule(lhs="node", rhs="FALSE")
    protected ModelNode parseFalse() {
        return new ModelNode().set(Boolean.FALSE);
    }

    @Rules(rules={@Rule(lhs="node", rhs="INT_HEX_VAL", args="1")})
    protected ModelNode parseIntHex(String arg) {
        return new ModelNode().set(Integer.parseInt(arg.substring(2), 16));
    }

    @Rules(rules={@Rule(lhs="node", rhs="LONG_HEX_VAL", args="1")})
    protected ModelNode parseLongHex(String arg) {
        return new ModelNode().set(Long.parseLong(arg.substring(2), 16));
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_BRACKET CLOSE_BRACKET")})
    protected ModelNode parseEmptyList() {
        return new ModelNode().setEmptyList();
    }

    @Rules(rules={@Rule(lhs="list", rhs="OPEN_BRACKET node", args="2")})
    protected ModelNode parseStartList(ModelNode child) {
        return new ModelNode().addNoCopy(child);
    }

    @Rules(rules={@Rule(lhs="list", rhs="list COMMA node", args="1 3")})
    protected ModelNode parseListItem(ModelNode list, ModelNode child) {
        return list.addNoCopy(child);
    }

    @Rules(rules={@Rule(lhs="node", rhs="list CLOSE_BRACKET", args="1"), @Rule(lhs="node", rhs="list COMMA CLOSE_BRACKET", args="1")})
    protected ModelNode finishList(ModelNode list) {
        return list;
    }

    @Rules(rules={@Rule(lhs="node", rhs="OPEN_BRACE CLOSE_BRACE")})
    protected ModelNode parseEmptyObject() {
        return new ModelNode().setEmptyObject();
    }

    @Rules(rules={@Rule(lhs="object", rhs="OPEN_BRACE STR_VAL COLON node", args="2 4")})
    protected ModelNode parseStartObject(String key, ModelNode child) {
        if ("TYPE_MODEL_VALUE".equals(key)) {
            return this.parseType(child.toString().replaceAll("\"", ""));
        }
        if ("BYTES_VALUE".equals(key)) {
            return this.parseBase64(child.toString().replaceAll("\"", ""));
        }
        if ("EXPRESSION_VALUE".equals(key)) {
            return this.parseExpression(child.toString().replaceAll("\"", ""));
        }
        if ("PROPERTY_VALUE".equals(key)) {
            return this.parseProperty(child);
        }
        ModelNode node = new ModelNode();
        node.get(key).setNoCopy(child);
        return node;
    }

    @Rules(rules={@Rule(lhs="object", rhs="object COMMA STR_VAL COLON node", args="1 3 5")})
    protected ModelNode parseObjectItem(ModelNode object, String key, ModelNode child) {
        object.get(key).setNoCopy(child);
        return object;
    }

    @Rules(rules={@Rule(lhs="node", rhs="object CLOSE_BRACE", args="1"), @Rule(lhs="node", rhs="object COMMA CLOSE_BRACE", args="1")})
    protected ModelNode finishObject(ModelNode object) {
        return object;
    }

    @Rules(rules={@Rule(lhs="node", rhs="STR_VAL", args="1")})
    protected ModelNode parseString(String arg) {
        return new ModelNode().set(arg);
    }

    @Rule(lhs="node", rhs="UNDEFINED")
    protected ModelNode parseUndefined() {
        return new ModelNode();
    }

    private ModelNode parseType(String arg) {
        return new ModelNode().set(ModelType.valueOf(arg));
    }

    private ModelNode parseBase64(String arg) {
        ModelNode node = new ModelNode();
        node.set(Base64.decode(arg));
        return node;
    }

    private ModelNode parseExpression(String arg) {
        return new ModelNode().setExpression(arg);
    }

    private ModelNode parseProperty(ModelNode value) {
        return new ModelNode().set(value.asProperty());
    }

    public ModelNode getResult() {
        return this.result;
    }

    @CookCCToken
    static enum Token {
        OPEN_BRACE,
        CLOSE_BRACE,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        COLON,
        COMMA,
        BIG,
        INTEGER,
        DECIMAL,
        UNDEFINED,
        TRUE,
        FALSE,
        INT_VAL,
        INT_HEX_VAL,
        LONG_VAL,
        LONG_HEX_VAL,
        DOUBLE_SPECIAL_VAL,
        DEC_VAL,
        STR_VAL;

    }
}

