/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetVisibleToAllUsersRequestMarshaller
implements Marshaller<Request<SetVisibleToAllUsersRequest>, SetVisibleToAllUsersRequest> {
    @Override
    public Request<SetVisibleToAllUsersRequest> marshall(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) {
        if (setVisibleToAllUsersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetVisibleToAllUsersRequest> request = new DefaultRequest<SetVisibleToAllUsersRequest>(setVisibleToAllUsersRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "SetVisibleToAllUsers");
        request.addParameter("Version", "2009-03-31");
        List<String> jobFlowIdsList = setVisibleToAllUsersRequest.getJobFlowIds();
        int jobFlowIdsListIndex = 1;
        for (String jobFlowIdsListValue : jobFlowIdsList) {
            if (jobFlowIdsListValue != null) {
                request.addParameter("JobFlowIds.member." + jobFlowIdsListIndex, StringUtils.fromString(jobFlowIdsListValue));
            }
            ++jobFlowIdsListIndex;
        }
        if (setVisibleToAllUsersRequest.isVisibleToAllUsers() != null) {
            request.addParameter("VisibleToAllUsers", StringUtils.fromBoolean(setVisibleToAllUsersRequest.isVisibleToAllUsers()));
        }
        return request;
    }
}

