/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.services.rds.model.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionGroup {
    private String optionGroupName;
    private String optionGroupDescription;
    private String engineName;
    private String majorEngineVersion;
    private List<Option> options;
    private Boolean allowsVpcAndNonVpcInstanceMemberships;
    private String vpcId;

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public OptionGroup withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public String getOptionGroupDescription() {
        return this.optionGroupDescription;
    }

    public void setOptionGroupDescription(String optionGroupDescription) {
        this.optionGroupDescription = optionGroupDescription;
    }

    public OptionGroup withOptionGroupDescription(String optionGroupDescription) {
        this.optionGroupDescription = optionGroupDescription;
        return this;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public OptionGroup withEngineName(String engineName) {
        this.engineName = engineName;
        return this;
    }

    public String getMajorEngineVersion() {
        return this.majorEngineVersion;
    }

    public void setMajorEngineVersion(String majorEngineVersion) {
        this.majorEngineVersion = majorEngineVersion;
    }

    public OptionGroup withMajorEngineVersion(String majorEngineVersion) {
        this.majorEngineVersion = majorEngineVersion;
        return this;
    }

    public List<Option> getOptions() {
        if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        return this.options;
    }

    public void setOptions(Collection<Option> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        ArrayList<Option> optionsCopy = new ArrayList<Option>(options.size());
        optionsCopy.addAll(options);
        this.options = optionsCopy;
    }

    public OptionGroup withOptions(Option ... options) {
        if (this.getOptions() == null) {
            this.setOptions(new ArrayList<Option>(options.length));
        }
        for (Option value : options) {
            this.getOptions().add(value);
        }
        return this;
    }

    public OptionGroup withOptions(Collection<Option> options) {
        if (options == null) {
            this.options = null;
        } else {
            ArrayList<Option> optionsCopy = new ArrayList<Option>(options.size());
            optionsCopy.addAll(options);
            this.options = optionsCopy;
        }
        return this;
    }

    public Boolean isAllowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public void setAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
        this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
    }

    public OptionGroup withAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
        this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
        return this;
    }

    public Boolean getAllowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public OptionGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: " + this.getOptionGroupName() + ", ");
        }
        if (this.getOptionGroupDescription() != null) {
            sb.append("OptionGroupDescription: " + this.getOptionGroupDescription() + ", ");
        }
        if (this.getEngineName() != null) {
            sb.append("EngineName: " + this.getEngineName() + ", ");
        }
        if (this.getMajorEngineVersion() != null) {
            sb.append("MajorEngineVersion: " + this.getMajorEngineVersion() + ", ");
        }
        if (this.getOptions() != null) {
            sb.append("Options: " + this.getOptions() + ", ");
        }
        if (this.isAllowsVpcAndNonVpcInstanceMemberships() != null) {
            sb.append("AllowsVpcAndNonVpcInstanceMemberships: " + this.isAllowsVpcAndNonVpcInstanceMemberships() + ", ");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupDescription() == null ? 0 : this.getOptionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEngineName() == null ? 0 : this.getEngineName().hashCode());
        hashCode = 31 * hashCode + (this.getMajorEngineVersion() == null ? 0 : this.getMajorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : ((Object)this.getOptions()).hashCode());
        hashCode = 31 * hashCode + (this.isAllowsVpcAndNonVpcInstanceMemberships() == null ? 0 : this.isAllowsVpcAndNonVpcInstanceMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroup)) {
            return false;
        }
        OptionGroup other = (OptionGroup)obj;
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getOptionGroupDescription() == null ^ this.getOptionGroupDescription() == null) {
            return false;
        }
        if (other.getOptionGroupDescription() != null && !other.getOptionGroupDescription().equals(this.getOptionGroupDescription())) {
            return false;
        }
        if (other.getEngineName() == null ^ this.getEngineName() == null) {
            return false;
        }
        if (other.getEngineName() != null && !other.getEngineName().equals(this.getEngineName())) {
            return false;
        }
        if (other.getMajorEngineVersion() == null ^ this.getMajorEngineVersion() == null) {
            return false;
        }
        if (other.getMajorEngineVersion() != null && !other.getMajorEngineVersion().equals(this.getMajorEngineVersion())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !((Object)other.getOptions()).equals(this.getOptions())) {
            return false;
        }
        if (other.isAllowsVpcAndNonVpcInstanceMemberships() == null ^ this.isAllowsVpcAndNonVpcInstanceMemberships() == null) {
            return false;
        }
        if (other.isAllowsVpcAndNonVpcInstanceMemberships() != null && !other.isAllowsVpcAndNonVpcInstanceMemberships().equals(this.isAllowsVpcAndNonVpcInstanceMemberships())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        return other.getVpcId() == null || other.getVpcId().equals(this.getVpcId());
    }
}

