/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionInfoUtils {
    private static final String VERSION_INFO_FILE = "com/amazonaws/sdk/versionInfo.properties";
    private static String version = null;
    private static String platform = null;
    private static String userAgent = null;
    private static Log log = LogFactory.getLog(VersionInfoUtils.class);

    public static String getVersion() {
        if (version == null) {
            VersionInfoUtils.initializeVersion();
        }
        return version;
    }

    public static String getPlatform() {
        if (platform == null) {
            VersionInfoUtils.initializeVersion();
        }
        return platform;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            VersionInfoUtils.initializeUserAgent();
        }
        return userAgent;
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfoUtils.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("com/amazonaws/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
            platform = versionInfoProperties.getProperty("platform");
        }
        catch (Exception e) {
            log.info((Object)("Unable to load version information for the running SDK: " + e.getMessage()));
            version = "unknown-version";
            platform = "java";
        }
    }

    private static void initializeUserAgent() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("aws-sdk-" + VersionInfoUtils.getPlatform().toLowerCase() + "/");
        buffer.append(VersionInfoUtils.getVersion());
        buffer.append(" ");
        buffer.append(System.getProperty("os.name").replace(' ', '_') + "/" + System.getProperty("os.version").replace(' ', '_'));
        buffer.append(" ");
        buffer.append(System.getProperty("java.vm.name").replace(' ', '_') + "/" + System.getProperty("java.vm.version").replace(' ', '_'));
        String region = "";
        try {
            region = " " + System.getProperty("user.language").replace(' ', '_') + "_" + System.getProperty("user.region").replace(' ', '_');
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer.append(region);
        userAgent = buffer.toString();
    }
}

