/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eigenbase.resgen.ResourceInstance;

public class ResourceDefinition {
    public final String key;
    public final String baseMessage;
    private final String[] props;
    private static final String[] EmptyStringArray;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_DATE = 2;
    public static final int TYPE_TIME = 3;
    private static final String[] TypeNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResourceDefinition(String string, String string2) {
        this(string, string2, null);
    }

    public ResourceDefinition(String string, String string2, String[] stringArray) {
        this.key = string;
        this.baseMessage = string2;
        if (stringArray == null) {
            stringArray = EmptyStringArray;
        }
        if (!$assertionsDisabled && stringArray.length % 2 != 0) {
            throw new AssertionError((Object)"Must have even number of property names/values");
        }
        this.props = stringArray;
    }

    public String getKey() {
        return this.key;
    }

    public String getBaseMessage() {
        return this.baseMessage;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (int i = 0; i < this.props.length; ++i) {
            String string = this.props[i];
            String string2 = this.props[++i];
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public String[] getArgTypes() {
        return ResourceDefinition.getArgTypes(this.baseMessage, TypeNames);
    }

    public ResourceInstance instantiate(ResourceBundle resourceBundle, Object[] objectArray) {
        return new Instance(resourceBundle, this, objectArray);
    }

    protected static String[] getArgTypes(String string, String[] stringArray) {
        if (!$assertionsDisabled && stringArray.length != 4) {
            throw new AssertionError();
        }
        try {
            Method method = MessageFormat.class.getMethod("getFormatsByArgumentIndex", null);
            try {
                MessageFormat messageFormat = new MessageFormat(string);
                Format[] formatArray = (Format[])method.invoke((Object)messageFormat, (Object[])null);
                String[] stringArray2 = new String[formatArray.length];
                for (int i = 0; i < formatArray.length; ++i) {
                    int n = ResourceDefinition.formatToType(formatArray[i]);
                    stringArray2[i] = stringArray[n];
                }
                return stringArray2;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.toString());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return ResourceDefinition.getArgTypesByHand(string, stringArray);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException.toString());
        }
    }

    protected static String[] getArgTypesByHand(String string, String[] stringArray) {
        if (!$assertionsDisabled && stringArray.length != 4) {
            throw new AssertionError();
        }
        String[] stringArray2 = new String[10];
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            int n2 = ResourceDefinition.getArgType(i, string);
            if (n2 == -1) continue;
            n = i + 1;
            stringArray2[i] = stringArray[n2];
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    protected static int getArgType(int n, String string) {
        String string2 = "{" + Integer.toString(n);
        int n2 = string.lastIndexOf(string2);
        if (n2 < 0) {
            return -1;
        }
        n2 += string2.length();
        int n3 = string.length();
        while (n2 < n3 && string.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 < n3 && string.charAt(n2) == ',') {
            ++n2;
            while (n2 < n3 && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 < n3) {
                String string3 = string.substring(n2);
                if (string3.startsWith("number")) {
                    return 1;
                }
                if (string3.startsWith("date")) {
                    return 2;
                }
                if (string3.startsWith("time")) {
                    return 3;
                }
                if (string3.startsWith("choice")) {
                    return -1;
                }
            }
        }
        return 0;
    }

    private static int formatToType(Format format) {
        if (format == null) {
            return 0;
        }
        if (format instanceof NumberFormat) {
            return 1;
        }
        if (format instanceof DateFormat) {
            return 2;
        }
        return 0;
    }

    static {
        $assertionsDisabled = !ResourceDefinition.class.desiredAssertionStatus();
        EmptyStringArray = new String[0];
        TypeNames = new String[]{"string", "number", "date", "time"};
    }

    private static class Instance
    implements ResourceInstance {
        ResourceDefinition definition;
        ResourceBundle bundle;
        Object[] args;

        public Instance(ResourceBundle resourceBundle, ResourceDefinition resourceDefinition, Object[] objectArray) {
            this.definition = resourceDefinition;
            this.bundle = resourceBundle;
            this.args = objectArray;
        }

        public String toString() {
            String string = this.bundle.getString(this.definition.key);
            MessageFormat messageFormat = new MessageFormat(string);
            messageFormat.setLocale(this.bundle.getLocale());
            String string2 = messageFormat.format(this.args);
            return string2;
        }
    }
}

